/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.expression;

import cn.taketoday.context.factory.BeanMetadata;
import cn.taketoday.context.factory.BeanProperty;
import cn.taketoday.expression.ExpressionContext;
import cn.taketoday.expression.ExpressionException;
import cn.taketoday.expression.ExpressionResolver;
import cn.taketoday.expression.PropertyNotFoundException;
import cn.taketoday.expression.PropertyNotWritableException;
import cn.taketoday.expression.util.ReflectionUtil;
import java.util.Objects;

public class BeanExpressionResolver
extends ExpressionResolver {
    private final boolean isReadOnly;

    public BeanExpressionResolver() {
        this(false);
    }

    public BeanExpressionResolver(boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
    }

    @Override
    public Class<?> getType(ExpressionContext context, Object base, Object property) {
        if (base == null || property == null) {
            return null;
        }
        BeanProperty beanProperty = this.getProperty(base, property);
        Objects.requireNonNull(context).setPropertyResolved(true);
        return beanProperty.getType();
    }

    @Override
    public Object getValue(ExpressionContext context, Object base, Object property) {
        if (base == null || property == null) {
            return null;
        }
        BeanProperty beanProperty = this.getProperty(base, property);
        try {
            Object value = beanProperty.getValue(base);
            Objects.requireNonNull(context).setPropertyResolved(base, property);
            return value;
        }
        catch (Exception ex) {
            throw new ExpressionException(ex);
        }
    }

    @Override
    public void setValue(ExpressionContext context, Object base, Object property, Object val) {
        if (base == null || property == null) {
            return;
        }
        if (this.isReadOnly) {
            throw new PropertyNotWritableException("The ELResolver for the class '" + base.getClass().getName() + "' is not writable.");
        }
        BeanProperty beanProperty = this.getProperty(base, property);
        try {
            beanProperty.setValue(base, val);
            Objects.requireNonNull(context).setPropertyResolved(base, property);
        }
        catch (Exception ex) {
            StringBuilder message = new StringBuilder("Can't set property '").append(property.toString()).append("' on class '").append(base.getClass().getName()).append("' to value '").append(val).append("'.");
            throw new ExpressionException(message.toString(), ex);
        }
    }

    @Override
    public Object invoke(ExpressionContext context, Object base, Object method, Class<?>[] paramTypes, Object[] params) {
        if (base == null || method == null) {
            return null;
        }
        Object ret = ReflectionUtil.invokeMethod(Objects.requireNonNull(context), ReflectionUtil.findMethod(base.getClass(), method.toString(), paramTypes, params, false), base, params);
        context.setPropertyResolved(base, method);
        return ret;
    }

    @Override
    public boolean isReadOnly(ExpressionContext context, Object base, Object property) {
        if (base == null || property == null) {
            return false;
        }
        Objects.requireNonNull(context).setPropertyResolved(true);
        return this.isReadOnly;
    }

    private BeanProperty getProperty(Object base, Object prop) throws PropertyNotFoundException {
        BeanProperty beanProperty = BeanMetadata.ofObject(base).getBeanProperty(prop.toString());
        if (beanProperty == null) {
            throw new PropertyNotFoundException("The class '" + base.getClass().getName() + "' does not have the property '" + prop + "'.");
        }
        return beanProperty;
    }
}

