/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.expression;

import cn.taketoday.expression.ExpressionContext;
import cn.taketoday.expression.ExpressionResolver;
import cn.taketoday.expression.PropertyNotFoundException;
import cn.taketoday.expression.PropertyNotWritableException;
import java.lang.reflect.Array;
import java.util.Objects;

public class ArrayExpressionResolver
extends ExpressionResolver {
    private boolean isReadOnly;

    public ArrayExpressionResolver() {
        this.isReadOnly = false;
    }

    public ArrayExpressionResolver(boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
    }

    @Override
    public Class<?> getType(ExpressionContext context, Object base, Object property) {
        Class<?> beanClass;
        if (base != null && (beanClass = base.getClass()).isArray()) {
            Objects.requireNonNull(context).setPropertyResolved(true);
            int index = this.toInteger(property);
            if (index < 0 || index >= Array.getLength(base)) {
                throw new PropertyNotFoundException();
            }
            return beanClass.getComponentType();
        }
        return null;
    }

    @Override
    public Object getValue(ExpressionContext context, Object base, Object property) {
        Objects.requireNonNull(context);
        if (base != null && base.getClass().isArray()) {
            Objects.requireNonNull(context).setPropertyResolved(base, property);
            int index = this.toInteger(property);
            if (index >= 0 && index < Array.getLength(base)) {
                return Array.get(base, index);
            }
        }
        return null;
    }

    @Override
    public void setValue(ExpressionContext context, Object base, Object property, Object val) {
        Class<?> beanClass;
        if (base != null && (beanClass = base.getClass()).isArray()) {
            Objects.requireNonNull(context).setPropertyResolved(base, property);
            if (this.isReadOnly) {
                throw new PropertyNotWritableException();
            }
            if (val != null && !beanClass.getComponentType().isInstance(val)) {
                throw new ClassCastException();
            }
            int index = this.toInteger(property);
            if (index < 0 || index >= Array.getLength(base)) {
                throw new PropertyNotFoundException();
            }
            Array.set(base, index, val);
        }
    }

    @Override
    public boolean isReadOnly(ExpressionContext context, Object base, Object property) {
        if (base != null && base.getClass().isArray()) {
            Objects.requireNonNull(context).setPropertyResolved(true);
            int index = this.toInteger(property);
            if (index < 0 || index >= Array.getLength(base)) {
                throw new PropertyNotFoundException();
            }
        }
        return this.isReadOnly;
    }

    private int toInteger(Object p) {
        if (p instanceof Integer) {
            return (Integer)p;
        }
        if (p instanceof Character) {
            return ((Character)p).charValue();
        }
        if (p instanceof Boolean) {
            return (Boolean)p != false ? 1 : 0;
        }
        if (p instanceof Number) {
            return ((Number)p).intValue();
        }
        if (p instanceof String) {
            return Integer.parseInt((String)p);
        }
        throw new IllegalArgumentException();
    }
}

