/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.utils;

import cn.taketoday.context.io.ClassPathResource;
import cn.taketoday.context.io.FileBasedResource;
import cn.taketoday.context.io.JarEntryResource;
import cn.taketoday.context.io.PathMatchingResourcePatternResolver;
import cn.taketoday.context.io.Resource;
import cn.taketoday.context.io.UrlBasedResource;
import cn.taketoday.context.utils.StringUtils;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;

public abstract class ResourceUtils {
    public static Resource[] getResources(String pathPattern) throws IOException {
        return ResourceUtils.getResources(pathPattern, null);
    }

    public static Resource[] getResources(String pathPattern, ClassLoader classLoader) throws IOException {
        return new PathMatchingResourcePatternResolver(classLoader).getResources(pathPattern);
    }

    public static Resource getResource(String location) {
        if (StringUtils.isEmpty(location)) {
            return new ClassPathResource("");
        }
        if (location.startsWith("classpath:")) {
            String path = StringUtils.decodeUrl(location.substring("classpath:".length()));
            return new ClassPathResource(path.charAt(0) == '/' ? path.substring(1) : path);
        }
        try {
            return ResourceUtils.getResource(ResourceUtils.toURL(location));
        }
        catch (MalformedURLException e) {
            return new ClassPathResource(location);
        }
    }

    public static URL toURL(String location) throws MalformedURLException {
        return new URL(location);
    }

    public static Resource getResource(URL url) {
        String protocol = url.getProtocol();
        if ("file".equals(protocol)) {
            return new FileBasedResource(StringUtils.decodeUrl(url.getPath()));
        }
        if ("jar".equals(protocol)) {
            return new JarEntryResource(url);
        }
        return new UrlBasedResource(url);
    }

    public static Resource getResource(File file) {
        return new FileBasedResource(file);
    }

    public static String getRelativePath(String path, String relativePath) {
        int separatorIndex = path.lastIndexOf(47);
        if (separatorIndex > 0) {
            StringBuilder newPath = new StringBuilder(path.substring(0, separatorIndex));
            if (relativePath.charAt(0) != '/') {
                newPath.append('/');
            }
            return newPath.append(relativePath).toString();
        }
        return relativePath;
    }

    public static boolean isFileURL(URL url) {
        String protocol = url.getProtocol();
        return "file".equals(protocol) || "vfsfile".equals(protocol);
    }

    public static boolean isJarURL(URL url) {
        String protocol = url.getProtocol();
        return "jar".equals(protocol) || "war".equals(protocol) || "zip".equals(protocol) || "vfszip".equals(protocol) || "wsjar".equals(protocol);
    }

    public static boolean isJarFileURL(URL url) {
        return "file".equals(url.getProtocol()) && url.getPath().toLowerCase().endsWith(".jar");
    }

    public static URL extractJarFileURL(URL jarUrl) throws MalformedURLException {
        String urlFile = jarUrl.getFile();
        int separatorIndex = urlFile.indexOf("!/");
        if (separatorIndex != -1) {
            String jarFile = urlFile.substring(0, separatorIndex);
            try {
                return new URL(jarFile);
            }
            catch (MalformedURLException ex) {
                if (!jarFile.startsWith("/")) {
                    jarFile = '/' + jarFile;
                }
                return new URL("file:".concat(jarFile));
            }
        }
        return jarUrl;
    }

    public static void useCachesIfNecessary(URLConnection con) {
        con.setUseCaches(con.getClass().getSimpleName().startsWith("JNLP"));
    }

    public static URI toURI(URL url) throws URISyntaxException {
        return ResourceUtils.toURI(url.toString());
    }

    public static URI toURI(String location) throws URISyntaxException {
        return new URI(StringUtils.replace(location, " ", "%20"));
    }

    public static boolean isUrl(String resourceLocation) {
        if (resourceLocation == null) {
            return false;
        }
        if (resourceLocation.startsWith("classpath:")) {
            return true;
        }
        try {
            new URL(resourceLocation);
            return true;
        }
        catch (MalformedURLException ex) {
            return false;
        }
    }

    public static URL extractArchiveURL(URL jarUrl) throws MalformedURLException {
        String urlFile = jarUrl.getFile();
        int endIndex = urlFile.indexOf("*/");
        if (endIndex != -1) {
            String warFile = urlFile.substring(0, endIndex);
            if ("war".equals(jarUrl.getProtocol())) {
                return new URL(warFile);
            }
            int startIndex = warFile.indexOf("war:");
            if (startIndex != -1) {
                return new URL(warFile.substring(startIndex + "war:".length()));
            }
        }
        return ResourceUtils.extractJarFileURL(jarUrl);
    }
}

