/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.utils;

import cn.taketoday.context.Constant;
import cn.taketoday.context.reflect.ArrayConstructor;
import cn.taketoday.context.reflect.BeanConstructor;
import cn.taketoday.context.reflect.CollectionConstructor;
import cn.taketoday.context.reflect.ConstructorAccessor;
import cn.taketoday.context.reflect.ConstructorAccessorBeanConstructor;
import cn.taketoday.context.reflect.ConstructorAccessorGenerator;
import cn.taketoday.context.reflect.FieldGetterMethod;
import cn.taketoday.context.reflect.FieldPropertyAccessor;
import cn.taketoday.context.reflect.FieldSetterMethod;
import cn.taketoday.context.reflect.GetterMethod;
import cn.taketoday.context.reflect.MapConstructor;
import cn.taketoday.context.reflect.MethodAccessorGetterMethod;
import cn.taketoday.context.reflect.MethodAccessorPropertyAccessor;
import cn.taketoday.context.reflect.MethodAccessorSetterMethod;
import cn.taketoday.context.reflect.MethodInvoker;
import cn.taketoday.context.reflect.PropertyAccessor;
import cn.taketoday.context.reflect.ReadOnlyFieldPropertyAccessor;
import cn.taketoday.context.reflect.ReadOnlyMethodAccessorPropertyAccessor;
import cn.taketoday.context.reflect.ReflectionException;
import cn.taketoday.context.reflect.SetterMethod;
import cn.taketoday.context.utils.Assert;
import cn.taketoday.context.utils.ClassUtils;
import cn.taketoday.context.utils.ConcurrentCache;
import cn.taketoday.context.utils.StringUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class ReflectionUtils {
    public static final MethodFilter USER_DECLARED_METHODS = method -> !method.isBridge() && !method.isSynthetic();
    public static final FieldFilter COPYABLE_FIELDS = field -> !Modifier.isStatic(field.getModifiers()) && !Modifier.isFinal(field.getModifiers());
    private static final String CGLIB_RENAMED_METHOD_PREFIX = "TODAY$";
    private static final Field[] EMPTY_FIELD_ARRAY = Constant.EMPTY_FIELD_ARRAY;
    private static final Method[] EMPTY_METHOD_ARRAY = Constant.EMPTY_METHOD_ARRAY;
    private static final Object[] EMPTY_OBJECT_ARRAY = Constant.EMPTY_OBJECT_ARRAY;
    private static final ConcurrentCache<Class<?>, Field[]> DECLARED_FIELDS_CACHE = ConcurrentCache.create(256);
    private static final ConcurrentCache<Class<?>, Method[]> DECLARED_METHODS_CACHE = ConcurrentCache.create(256);

    public static void handleReflectionException(Exception ex) {
        if (ex instanceof NoSuchMethodException) {
            throw new IllegalStateException("Method not found: " + ex.getMessage());
        }
        if (ex instanceof IllegalAccessException) {
            throw new IllegalStateException("Could not access method or field: " + ex.getMessage());
        }
        if (ex instanceof InvocationTargetException) {
            ReflectionUtils.handleInvocationTargetException((InvocationTargetException)ex);
        }
        if (ex instanceof RuntimeException) {
            throw (RuntimeException)ex;
        }
        throw new UndeclaredThrowableException(ex);
    }

    public static void handleInvocationTargetException(InvocationTargetException ex) {
        ReflectionUtils.rethrowRuntimeException(ex.getTargetException());
    }

    public static void rethrowRuntimeException(Throwable ex) {
        if (ex instanceof RuntimeException) {
            throw (RuntimeException)ex;
        }
        if (ex instanceof Error) {
            throw (Error)ex;
        }
        throw new UndeclaredThrowableException(ex);
    }

    public static void rethrowException(Throwable ex) throws Exception {
        if (ex instanceof Exception) {
            throw (Exception)ex;
        }
        if (ex instanceof Error) {
            throw (Error)ex;
        }
        throw new UndeclaredThrowableException(ex);
    }

    public static Method findMethod(Class<?> clazz, String name) {
        return ReflectionUtils.findMethod(clazz, name, null);
    }

    public static Method findMethod(Class<?> clazz, String name, Class<?> ... paramTypes) {
        Assert.notNull(clazz, "Class must not be null");
        Assert.notNull((Object)name, "Method name must not be null");
        for (Class<?> searchType = clazz; searchType != null; searchType = searchType.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = searchType.isInterface() ? searchType.getMethods() : ReflectionUtils.getDeclaredMethods(searchType, false)) {
                if (!name.equals(method.getName()) || paramTypes != null && !ReflectionUtils.hasSameParams(method, paramTypes)) continue;
                return method;
            }
        }
        return null;
    }

    private static boolean hasSameParams(Method method, Class<?>[] paramTypes) {
        return paramTypes.length == method.getParameterCount() && Arrays.equals(paramTypes, method.getParameterTypes());
    }

    public static Object invokeMethod(Method method, Object target) {
        return ReflectionUtils.invokeMethod(method, target, EMPTY_OBJECT_ARRAY);
    }

    public static Object invokeMethod(Method method, Object target, Object ... args) {
        try {
            return method.invoke(target, args);
        }
        catch (Exception ex) {
            ReflectionUtils.handleReflectionException(ex);
            throw new IllegalStateException("Should never get here");
        }
    }

    public static Object accessInvokeMethod(Method method, Object target, Object ... args) {
        return ReflectionUtils.invokeMethod(ReflectionUtils.makeAccessible(method), target, args);
    }

    public static Object invokeConstructor(Constructor<?> constructor, Object[] args) {
        try {
            return constructor.newInstance(args);
        }
        catch (Exception ex) {
            ReflectionUtils.handleReflectionException(ex);
            throw new IllegalStateException("Should never get here");
        }
    }

    public static boolean declaresException(Method method, Class<?> exceptionType) {
        Class<?>[] declaredExceptions;
        Assert.notNull((Object)method, "Method must not be null");
        for (Class<?> declaredException : declaredExceptions = method.getExceptionTypes()) {
            if (!declaredException.isAssignableFrom(exceptionType)) continue;
            return true;
        }
        return false;
    }

    public static void doWithLocalMethods(Class<?> clazz, MethodCallback mc) {
        Method[] methods;
        for (Method method : methods = ReflectionUtils.getDeclaredMethods(clazz, false)) {
            try {
                mc.doWith(method);
            }
            catch (IllegalAccessException ex) {
                throw new IllegalStateException("Not allowed to access method '" + method.getName() + "': " + ex);
            }
        }
    }

    public static void doWithMethods(Class<?> clazz, MethodCallback mc) {
        ReflectionUtils.doWithMethods(clazz, mc, null);
    }

    public static void doWithMethods(Class<?> clazz, MethodCallback mc, MethodFilter mf) {
        Method[] methods = ReflectionUtils.getDeclaredMethods(clazz, false);
        for (Method method : methods) {
            if (mf != null && !mf.matches(method)) continue;
            try {
                mc.doWith(method);
            }
            catch (IllegalAccessException ex) {
                throw new IllegalStateException("Not allowed to access method '" + method.getName() + "': " + ex);
            }
        }
        if (clazz.getSuperclass() != null && (mf != USER_DECLARED_METHODS || clazz.getSuperclass() != Object.class)) {
            ReflectionUtils.doWithMethods(clazz.getSuperclass(), mc, mf);
        } else if (clazz.isInterface()) {
            for (GenericDeclaration genericDeclaration : clazz.getInterfaces()) {
                ReflectionUtils.doWithMethods(genericDeclaration, mc, mf);
            }
        }
    }

    public static Method[] getAllDeclaredMethods(Class<?> leafClass) {
        ArrayList methods = new ArrayList(32);
        ReflectionUtils.doWithMethods(leafClass, methods::add);
        return methods.toArray(new Method[methods.size()]);
    }

    public static Method[] getDeclaredMethods(Class<?> targetClass) {
        return ReflectionUtils.getDeclaredMethods(targetClass, true);
    }

    private static Method[] getDeclaredMethods(Class<?> targetClass, boolean defensive) {
        Assert.notNull(targetClass, "targetClass must not be null");
        Method[] result = DECLARED_METHODS_CACHE.get(targetClass);
        if (result == null) {
            try {
                Method[] declaredMethods = targetClass.getDeclaredMethods();
                List<Method> defaultMethods = ReflectionUtils.findConcreteMethodsOnInterfaces(targetClass);
                if (defaultMethods != null) {
                    result = new Method[declaredMethods.length + defaultMethods.size()];
                    System.arraycopy(declaredMethods, 0, result, 0, declaredMethods.length);
                    int index = declaredMethods.length;
                    Iterator<Method> iterator = defaultMethods.iterator();
                    while (iterator.hasNext()) {
                        Method defaultMethod;
                        result[index] = defaultMethod = iterator.next();
                        ++index;
                    }
                } else {
                    result = declaredMethods;
                }
                DECLARED_METHODS_CACHE.put(targetClass, result.length == 0 ? EMPTY_METHOD_ARRAY : result);
            }
            catch (Throwable ex) {
                throw new IllegalStateException("Failed to introspect Class [" + targetClass.getName() + "] from ClassLoader [" + targetClass.getClassLoader() + "]", ex);
            }
        }
        return result.length == 0 || !defensive ? result : (Method[])result.clone();
    }

    private static List<Method> findConcreteMethodsOnInterfaces(Class<?> clazz) {
        ArrayList<Method> result = null;
        for (Class<?> ifc : clazz.getInterfaces()) {
            for (Method ifcMethod : ifc.getMethods()) {
                if (Modifier.isAbstract(ifcMethod.getModifiers())) continue;
                if (result == null) {
                    result = new ArrayList<Method>();
                }
                result.add(ifcMethod);
            }
        }
        return result;
    }

    public static Method[] getUniqueDeclaredMethods(Class<?> leafClass) {
        return ReflectionUtils.getUniqueDeclaredMethods(leafClass, null);
    }

    public static Method[] getUniqueDeclaredMethods(Class<?> leafClass, MethodFilter mf) {
        ArrayList methods = new ArrayList(32);
        ReflectionUtils.doWithMethods(leafClass, method -> {
            boolean knownSignature = false;
            Method methodBeingOverriddenWithCovariantReturnType = null;
            for (Method existingMethod : methods) {
                if (!method.getName().equals(existingMethod.getName()) || method.getParameterCount() != existingMethod.getParameterCount() || !Arrays.equals(method.getParameterTypes(), existingMethod.getParameterTypes())) continue;
                if (existingMethod.getReturnType() != method.getReturnType() && existingMethod.getReturnType().isAssignableFrom(method.getReturnType())) {
                    methodBeingOverriddenWithCovariantReturnType = existingMethod;
                    break;
                }
                knownSignature = true;
                break;
            }
            if (methodBeingOverriddenWithCovariantReturnType != null) {
                methods.remove(methodBeingOverriddenWithCovariantReturnType);
            }
            if (!knownSignature && !ReflectionUtils.isCglibRenamedMethod(method)) {
                methods.add(method);
            }
        }, mf);
        return methods.toArray(EMPTY_METHOD_ARRAY);
    }

    public static boolean isEqualsMethod(Method method) {
        if (method == null || !method.getName().equals("equals")) {
            return false;
        }
        if (method.getParameterCount() != 1) {
            return false;
        }
        return method.getParameterTypes()[0] == Object.class;
    }

    public static boolean isHashCodeMethod(Method method) {
        return method != null && method.getName().equals("hashCode") && method.getParameterCount() == 0;
    }

    public static boolean isToStringMethod(Method method) {
        return method != null && method.getName().equals("toString") && method.getParameterCount() == 0;
    }

    public static boolean isObjectMethod(Method method) {
        return method != null && (method.getDeclaringClass() == Object.class || ReflectionUtils.isEqualsMethod(method) || ReflectionUtils.isHashCodeMethod(method) || ReflectionUtils.isToStringMethod(method));
    }

    public static boolean isFinalizeMethod(Method method) {
        return method != null && method.getName().equals("finalize") && method.getParameterCount() == 0;
    }

    public static boolean isCglibRenamedMethod(Method renamedMethod) {
        String name = renamedMethod.getName();
        if (name.startsWith(CGLIB_RENAMED_METHOD_PREFIX)) {
            int i;
            for (i = name.length() - 1; i >= 0 && Character.isDigit(name.charAt(i)); --i) {
            }
            return i > CGLIB_RENAMED_METHOD_PREFIX.length() && i < name.length() - 1 && name.charAt(i) == '$';
        }
        return false;
    }

    public static Method makeAccessible(Method method) {
        if (!(Modifier.isPublic(method.getModifiers()) && Modifier.isPublic(method.getDeclaringClass().getModifiers()) || method.isAccessible())) {
            method.setAccessible(true);
        }
        return method;
    }

    public static Field findField(Class<?> clazz, String name) {
        return ReflectionUtils.findField(clazz, name, null);
    }

    public static Field findField(Class<?> clazz, String name, Class<?> type) {
        Assert.notNull(clazz, "Class must not be null");
        Assert.isTrue(name != null || type != null, "Either name or type of the field must be specified");
        for (Class<?> searchType = clazz; Object.class != searchType && searchType != null; searchType = searchType.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = ReflectionUtils.getDeclaredFields(searchType)) {
                if (name != null && !name.equals(field.getName()) || type != null && !type.equals(field.getType())) continue;
                return field;
            }
        }
        return null;
    }

    public static void setField(Field field, Object target, Object value) {
        try {
            field.set(target, value);
        }
        catch (IllegalAccessException ex) {
            ReflectionUtils.handleReflectionException(ex);
        }
    }

    public static Object getField(Field field, Object target) {
        try {
            return field.get(target);
        }
        catch (IllegalAccessException ex) {
            ReflectionUtils.handleReflectionException(ex);
            throw new IllegalStateException("Should never get here");
        }
    }

    public static void doWithLocalFields(Class<?> clazz, FieldCallback fc) {
        for (Field field : ReflectionUtils.getDeclaredFields(clazz)) {
            try {
                fc.doWith(field);
            }
            catch (IllegalAccessException ex) {
                throw new IllegalStateException("Not allowed to access field '" + field.getName() + "': " + ex);
            }
        }
    }

    public static void doWithFields(Class<?> clazz, FieldCallback fc) {
        ReflectionUtils.doWithFields(clazz, fc, null);
    }

    public static void doWithFields(Class<?> clazz, FieldCallback fc, FieldFilter ff) {
        Class<?> targetClass = clazz;
        do {
            Field[] fields;
            for (Field field : fields = ReflectionUtils.getDeclaredFields(targetClass)) {
                if (ff != null && !ff.matches(field)) continue;
                try {
                    fc.doWith(field);
                }
                catch (IllegalAccessException ex) {
                    throw new IllegalStateException("Not allowed to access field '" + field.getName() + "': " + ex);
                }
            }
        } while ((targetClass = targetClass.getSuperclass()) != null && targetClass != Object.class);
    }

    private static Field[] getDeclaredFields(Class<?> clazz) {
        Assert.notNull(clazz, "Class must not be null");
        Field[] result = DECLARED_FIELDS_CACHE.get(clazz);
        if (result == null) {
            try {
                result = clazz.getDeclaredFields();
                DECLARED_FIELDS_CACHE.put(clazz, result.length == 0 ? EMPTY_FIELD_ARRAY : result);
            }
            catch (Throwable ex) {
                throw new IllegalStateException("Failed to introspect Class [" + clazz.getName() + "] from ClassLoader [" + clazz.getClassLoader() + "]", ex);
            }
        }
        return result;
    }

    public static void shallowCopyFieldState(final Object src, final Object dest) {
        Assert.notNull(src, "Source for field copy cannot be null");
        Assert.notNull(dest, "Destination for field copy cannot be null");
        if (!src.getClass().isAssignableFrom(dest.getClass())) {
            throw new IllegalArgumentException("Destination class [" + dest.getClass().getName() + "] must be same or subclass as source class [" + src.getClass().getName() + "]");
        }
        final class FieldCallback0
        implements FieldCallback {
            FieldCallback0() {
            }

            @Override
            public void doWith(Field field) {
                ReflectionUtils.copyField(field, src, dest);
            }
        }
        ReflectionUtils.doWithFields(src.getClass(), new FieldCallback0(), COPYABLE_FIELDS);
    }

    public static void copyField(Field field, Object src, Object dest) {
        ReflectionUtils.makeAccessible(field);
        ReflectionUtils.setField(field, dest, ReflectionUtils.getField(field, src));
    }

    public static Field makeAccessible(Field field) {
        if (!(Modifier.isPublic(field.getModifiers()) && Modifier.isPublic(field.getDeclaringClass().getModifiers()) && !Modifier.isFinal(field.getModifiers()) || field.isAccessible())) {
            field.setAccessible(true);
        }
        return field;
    }

    public static boolean isPublicStaticFinal(Field field) {
        int modifiers = field.getModifiers();
        return Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers);
    }

    public static Collection<Field> getFields(Object target) {
        return ReflectionUtils.getFields(target.getClass());
    }

    public static Collection<Field> getFields(Class<?> targetClass) {
        ArrayList<Field> list = new ArrayList<Field>(64);
        do {
            Collections.addAll(list, ReflectionUtils.getDeclaredFields(targetClass));
        } while ((targetClass = targetClass.getSuperclass()) != Object.class && targetClass != null);
        return list;
    }

    public static Field[] getFieldArray(Class<?> targetClass) {
        Collection<Field> fields = ReflectionUtils.getFields(targetClass);
        return fields.toArray(new Field[fields.size()]);
    }

    public static <T> Constructor<T> accessibleConstructor(Class<T> targetClass, Class<?> ... parameterTypes) throws NoSuchMethodException {
        Assert.notNull(targetClass, "targetClass must not be null");
        return ReflectionUtils.makeAccessible(targetClass.getDeclaredConstructor(parameterTypes));
    }

    public static <T> Constructor<T> makeAccessible(Constructor<T> constructor) {
        Assert.notNull(constructor, "constructor must not be null");
        if (!(Modifier.isPublic(constructor.getModifiers()) && Modifier.isPublic(constructor.getDeclaringClass().getModifiers()) || constructor.isAccessible())) {
            constructor.setAccessible(true);
        }
        return constructor;
    }

    public static void clearCache() {
        DECLARED_FIELDS_CACHE.clear();
        DECLARED_METHODS_CACHE.clear();
    }

    public static Field obtainField(Class<?> clazz, String name) {
        Field field = ReflectionUtils.findField(clazz, name);
        if (field == null) {
            throw new ReflectionException("No such field named: " + name + " in class: " + clazz.getName());
        }
        return field;
    }

    public static Method obtainMethod(String methodName, Class<?> targetClass, Class<?> ... parameterTypes) {
        Method declaredMethod = ReflectionUtils.findMethod(targetClass, methodName, parameterTypes);
        if (declaredMethod == null) {
            throw new ReflectionException("No such method named: " + methodName + " in class: " + targetClass.getName());
        }
        return declaredMethod;
    }

    public static PropertyAccessor newPropertyAccessor(final Field field) {
        Assert.notNull((Object)field, "field must not be null");
        String propertyName = field.getName();
        String capitalizeProperty = StringUtils.capitalize(propertyName);
        Class<?> type = field.getType();
        Class<?> declaringClass = field.getDeclaringClass();
        final Method readMethod = ReflectionUtils.findMethod(declaringClass, ReflectionUtils.getterPropertyName(capitalizeProperty, type));
        boolean isReadOnly = Modifier.isFinal(field.getModifiers());
        if (isReadOnly && readMethod != null) {
            return new ReadOnlyMethodAccessorPropertyAccessor(ReflectionUtils.newMethodAccessor(readMethod));
        }
        final Method writeMethod = ReflectionUtils.findMethod(declaringClass, "set".concat(capitalizeProperty), type);
        if (writeMethod != null && readMethod != null) {
            return new MethodAccessorPropertyAccessor(type.isPrimitive(), writeMethod, readMethod);
        }
        if (writeMethod != null) {
            final MethodInvoker accessor = ReflectionUtils.newMethodAccessor(writeMethod);
            ReflectionUtils.makeAccessible(field);
            return new PropertyAccessor(){

                @Override
                public Object get(Object obj) {
                    return ReflectionUtils.getField(field, obj);
                }

                @Override
                public void set(Object obj, Object value) {
                    accessor.invoke(obj, new Object[]{value});
                }

                @Override
                public Method getWriteMethod() {
                    return writeMethod;
                }
            };
        }
        if (readMethod != null) {
            ReflectionUtils.makeAccessible(field);
            final MethodInvoker accessor = ReflectionUtils.newMethodAccessor(readMethod);
            return new PropertyAccessor(){

                @Override
                public Object get(Object obj) {
                    return accessor.invoke(obj, null);
                }

                @Override
                public void set(Object obj, Object value) {
                    ReflectionUtils.setField(field, obj, value);
                }

                @Override
                public Method getReadMethod() {
                    return readMethod;
                }
            };
        }
        return isReadOnly ? new ReadOnlyFieldPropertyAccessor(field, null) : new FieldPropertyAccessor(field, null, null);
    }

    public static MethodInvoker newMethodAccessor(Method method) {
        return MethodInvoker.create(method);
    }

    public static ConstructorAccessor newConstructorAccessor(Class<?> target) {
        Assert.notNull(target, "target class must not be null");
        if (target.isArray()) {
            Class<?> componentType = target.getComponentType();
            return new ArrayConstructor(componentType);
        }
        if (Collection.class.isAssignableFrom(target)) {
            return new CollectionConstructor(target);
        }
        if (Map.class.isAssignableFrom(target)) {
            return new MapConstructor(target);
        }
        try {
            Constructor<?> constructor = target.getDeclaredConstructor(new Class[0]);
            return ReflectionUtils.newConstructorAccessor(constructor);
        }
        catch (NoSuchMethodException e) {
            throw new ReflectionException("Target class: '" + target + "\u2018 has no default constructor");
        }
    }

    public static ConstructorAccessor newConstructorAccessor(Constructor<?> constructor) {
        return (ConstructorAccessor)new ConstructorAccessorGenerator(constructor).create();
    }

    public static <T> BeanConstructor<T> newConstructor(Class<T> targetClass) {
        Constructor<T> suitableConstructor = ClassUtils.getSuitableConstructor(targetClass);
        if (suitableConstructor == null) {
            throw new ReflectionException("No suitable constructor in class: " + targetClass);
        }
        return new ConstructorAccessorBeanConstructor<T>(suitableConstructor);
    }

    public static GetterMethod newGetterMethod(Field field) {
        Assert.notNull((Object)field, "field must not be null");
        try {
            return ReflectionUtils.newGetterMethod(field.getName(), field.getType(), field.getDeclaringClass());
        }
        catch (ReflectionException e) {
            return new FieldGetterMethod(field);
        }
    }

    public static GetterMethod newGetterMethod(String name, Class<?> type, Class<?> declaringClass) {
        return ReflectionUtils.newGetterMethod(ReflectionUtils.obtainMethod(ReflectionUtils.getterPropertyName(name, type), declaringClass, type));
    }

    private static String getterPropertyName(String name, Class<?> type) {
        return (type == Boolean.TYPE ? "is" : "get").concat(name);
    }

    public static GetterMethod newGetterMethod(Method method) {
        return new MethodAccessorGetterMethod(MethodInvoker.create(method));
    }

    public static SetterMethod newSetterMethod(Field field) {
        try {
            return ReflectionUtils.newSetterMethod(field.getName(), field.getType(), field.getDeclaringClass());
        }
        catch (ReflectionException e) {
            return new FieldSetterMethod(field);
        }
    }

    public static SetterMethod newSetterMethod(String name, Class<?> type, Class<?> declaringClass) {
        Method setMethod = ReflectionUtils.obtainMethod("set".concat(StringUtils.capitalize(name)), declaringClass, type);
        return ReflectionUtils.newSetterMethod(setMethod, type);
    }

    public static SetterMethod newSetterMethod(Method method) {
        return ReflectionUtils.newSetterMethod(method, method.getParameterTypes()[0]);
    }

    public static SetterMethod newSetterMethod(Method method, Class<?> type) {
        MethodInvoker accessor = MethodInvoker.create(method);
        boolean primitive = type.isPrimitive();
        return new MethodAccessorSetterMethod(primitive, accessor);
    }

    @FunctionalInterface
    public static interface FieldFilter {
        public boolean matches(Field var1);
    }

    @FunctionalInterface
    public static interface FieldCallback {
        public void doWith(Field var1) throws IllegalArgumentException, IllegalAccessException;
    }

    @FunctionalInterface
    public static interface MethodFilter {
        public boolean matches(Method var1);
    }

    @FunctionalInterface
    public static interface MethodCallback {
        public void doWith(Method var1) throws IllegalArgumentException, IllegalAccessException;
    }
}

