/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.utils;

import cn.taketoday.context.Constant;
import cn.taketoday.context.utils.Assert;
import cn.taketoday.context.utils.ConvertUtils;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public abstract class ObjectUtils {
    public static boolean isArray(Object obj) {
        return obj != null && obj.getClass().isArray();
    }

    public static boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof Optional) {
            return !((Optional)obj).isPresent();
        }
        if (obj instanceof String) {
            return ((String)obj).isEmpty();
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).isEmpty();
        }
        if (obj instanceof Map) {
            return ((Map)obj).isEmpty();
        }
        return obj.getClass().isArray() && Array.getLength(obj) == 0;
    }

    public static boolean isNotEmpty(Object[] array) {
        return !ObjectUtils.isEmpty(array);
    }

    public static boolean isNotEmpty(Object obj) {
        return !ObjectUtils.isEmpty(obj);
    }

    public static Object unwrapOptional(Object obj) {
        if (obj instanceof Optional) {
            Optional optional = (Optional)obj;
            if (!optional.isPresent()) {
                return null;
            }
            Object result = optional.get();
            Assert.isTrue(!(result instanceof Optional), "Multi-level Optional usage not supported");
            return result;
        }
        return obj;
    }

    public static Object toArrayObject(String[] source, Class<?> targetClass) {
        if (String[].class == targetClass) {
            return source;
        }
        int length = source.length;
        if (int[].class == targetClass) {
            int[] newInstance = new int[length];
            for (int j = 0; j < length; j = (int)((short)(j + 1))) {
                newInstance[j] = Integer.parseInt(source[j]);
            }
            return newInstance;
        }
        if (Integer[].class == targetClass) {
            Integer[] newInstance = new Integer[length];
            for (int j = 0; j < length; j = (int)((short)(j + 1))) {
                newInstance[j] = Integer.valueOf(source[j]);
            }
            return newInstance;
        }
        if (long[].class == targetClass) {
            long[] newInstance = new long[length];
            for (int j = 0; j < length; j = (int)((short)(j + 1))) {
                newInstance[j] = Long.parseLong(source[j]);
            }
            return newInstance;
        }
        if (Long[].class == targetClass) {
            Long[] newInstance = new Long[length];
            for (int j = 0; j < length; j = (int)((short)(j + 1))) {
                newInstance[j] = Long.valueOf(source[j]);
            }
            return newInstance;
        }
        if (short[].class == targetClass) {
            short[] newInstance = new short[length];
            for (int j = 0; j < length; j = (int)((short)(j + 1))) {
                newInstance[j] = Short.parseShort(source[j]);
            }
            return newInstance;
        }
        if (Short[].class == targetClass) {
            Short[] newInstance = new Short[length];
            for (int j = 0; j < length; j = (int)((short)(j + 1))) {
                newInstance[j] = Short.valueOf(source[j]);
            }
            return newInstance;
        }
        if (byte[].class == targetClass) {
            byte[] newInstance = new byte[length];
            for (int j = 0; j < length; j = (int)((short)(j + 1))) {
                newInstance[j] = Byte.parseByte(source[j]);
            }
            return newInstance;
        }
        if (Byte[].class == targetClass) {
            Byte[] newInstance = new Byte[length];
            for (int j = 0; j < length; j = (int)((short)(j + 1))) {
                newInstance[j] = Byte.valueOf(source[j]);
            }
            return newInstance;
        }
        if (float[].class == targetClass) {
            float[] newInstance = new float[length];
            for (int j = 0; j < length; j = (int)((short)(j + 1))) {
                newInstance[j] = Float.parseFloat(source[j]);
            }
            return newInstance;
        }
        if (Float[].class == targetClass) {
            Float[] newInstance = new Float[length];
            for (int j = 0; j < length; j = (int)((short)(j + 1))) {
                newInstance[j] = Float.valueOf(source[j]);
            }
            return newInstance;
        }
        if (double[].class == targetClass) {
            double[] newInstance = new double[length];
            for (int j = 0; j < length; j = (int)((short)(j + 1))) {
                newInstance[j] = Double.parseDouble(source[j]);
            }
            return newInstance;
        }
        if (Double[].class == targetClass) {
            Double[] newInstance = new Double[length];
            for (int j = 0; j < length; j = (int)((short)(j + 1))) {
                newInstance[j] = Double.valueOf(source[j]);
            }
            return newInstance;
        }
        if (targetClass.isArray()) {
            targetClass = targetClass.getComponentType();
        }
        Object newInstance = Array.newInstance(targetClass, length);
        for (int i = 0; i < length; i = (int)((short)(i + 1))) {
            Array.set(newInstance, i, ConvertUtils.convert(source[i], targetClass));
        }
        return newInstance;
    }

    public static <T> T parseArray(String[] source, Class<T> targetClass) {
        return targetClass.cast(ObjectUtils.toArrayObject(source, targetClass));
    }

    public static String toHexString(Object obj) {
        return obj == null ? "null" : obj.getClass().getName() + '@' + Integer.toHexString(obj.hashCode());
    }

    public static String identityToString(Object obj) {
        if (obj == null) {
            return "";
        }
        String className = obj.getClass().getName();
        String identityHexString = ObjectUtils.getIdentityHexString(obj);
        return className + '@' + identityHexString;
    }

    public static String getIdentityHexString(Object obj) {
        return Integer.toHexString(System.identityHashCode(obj));
    }

    public static boolean containsElement(Object[] array, Object element) {
        if (array == null) {
            return false;
        }
        for (Object arrayEle : array) {
            if (!Objects.equals(arrayEle, element)) continue;
            return true;
        }
        return false;
    }

    public static <A, O extends A> A[] addObjectToArray(A[] array, O obj) {
        Class compType = Object.class;
        if (array != null) {
            compType = array.getClass().getComponentType();
        } else if (obj != null) {
            compType = obj.getClass();
        }
        int newArrLength = array != null ? array.length + 1 : 1;
        Object[] newArr = (Object[])Array.newInstance(compType, newArrLength);
        if (array != null) {
            System.arraycopy(array, 0, newArr, 0, array.length);
        }
        newArr[newArr.length - 1] = obj;
        return newArr;
    }

    public static Object[] toObjectArray(Object source) {
        if (source instanceof Object[]) {
            return (Object[])source;
        }
        if (source == null) {
            return Constant.EMPTY_OBJECT_ARRAY;
        }
        if (!source.getClass().isArray()) {
            throw new IllegalArgumentException("Source is not an array: " + source);
        }
        int length = Array.getLength(source);
        if (length == 0) {
            return Constant.EMPTY_OBJECT_ARRAY;
        }
        Class<?> wrapperType = Array.get(source, 0).getClass();
        Object[] newArray = (Object[])Array.newInstance(wrapperType, length);
        for (int i = 0; i < length; ++i) {
            newArray[i] = Array.get(source, i);
        }
        return newArray;
    }
}

