/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.utils;

import cn.taketoday.context.Constant;
import cn.taketoday.context.io.Resource;
import cn.taketoday.context.utils.InvalidMediaTypeException;
import cn.taketoday.context.utils.InvalidMimeTypeException;
import cn.taketoday.context.utils.MimeType;
import cn.taketoday.context.utils.MimeTypeUtils;
import cn.taketoday.context.utils.ObjectUtils;
import cn.taketoday.context.utils.StringUtils;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class MediaType
extends MimeType
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final MediaType ALL = new MediaType("*", "*");
    public static final String ALL_VALUE = "*/*";
    public static final MediaType APPLICATION_ATOM_XML;
    public static final String APPLICATION_ATOM_XML_VALUE = "application/atom+xml";
    public static final MediaType APPLICATION_CBOR;
    public static final String APPLICATION_CBOR_VALUE = "application/cbor";
    public static final MediaType APPLICATION_FORM_URLENCODED;
    public static final String APPLICATION_FORM_URLENCODED_VALUE = "application/x-www-form-urlencoded";
    public static final MediaType APPLICATION_JSON;
    public static final String APPLICATION_JSON_VALUE = "application/json";
    @Deprecated
    public static final MediaType APPLICATION_JSON_UTF8;
    @Deprecated
    public static final String APPLICATION_JSON_UTF8_VALUE = "application/json;charset=UTF-8";
    public static final MediaType APPLICATION_OCTET_STREAM;
    public static final String APPLICATION_OCTET_STREAM_VALUE = "application/octet-stream";
    public static final MediaType APPLICATION_PDF;
    public static final String APPLICATION_PDF_VALUE = "application/pdf";
    public static final MediaType APPLICATION_PROBLEM_JSON;
    public static final String APPLICATION_PROBLEM_JSON_VALUE = "application/problem+json";
    @Deprecated
    public static final MediaType APPLICATION_PROBLEM_JSON_UTF8;
    @Deprecated
    public static final String APPLICATION_PROBLEM_JSON_UTF8_VALUE = "application/problem+json;charset=UTF-8";
    public static final MediaType APPLICATION_PROBLEM_XML;
    public static final String APPLICATION_PROBLEM_XML_VALUE = "application/problem+xml";
    public static final MediaType APPLICATION_RSS_XML;
    public static final String APPLICATION_RSS_XML_VALUE = "application/rss+xml";
    public static final MediaType APPLICATION_STREAM_JSON;
    public static final String APPLICATION_STREAM_JSON_VALUE = "application/stream+json";
    public static final MediaType APPLICATION_XHTML_XML;
    public static final String APPLICATION_XHTML_XML_VALUE = "application/xhtml+xml";
    public static final MediaType APPLICATION_XML;
    public static final String APPLICATION_XML_VALUE = "application/xml";
    public static final MediaType IMAGE_GIF;
    public static final String IMAGE_GIF_VALUE = "image/gif";
    public static final MediaType IMAGE_JPEG;
    public static final String IMAGE_JPEG_VALUE = "image/jpeg";
    public static final MediaType IMAGE_PNG;
    public static final String IMAGE_PNG_VALUE = "image/png";
    public static final MediaType MULTIPART_FORM_DATA;
    public static final String MULTIPART_FORM_DATA_VALUE = "multipart/form-data";
    public static final MediaType MULTIPART_MIXED;
    public static final String MULTIPART_MIXED_VALUE = "multipart/mixed";
    public static final MediaType TEXT_EVENT_STREAM;
    public static final String TEXT_EVENT_STREAM_VALUE = "text/event-stream";
    public static final MediaType TEXT_HTML;
    public static final String TEXT_HTML_VALUE = "text/html";
    public static final MediaType TEXT_MARKDOWN;
    public static final String TEXT_MARKDOWN_VALUE = "text/markdown";
    public static final MediaType TEXT_PLAIN;
    public static final String TEXT_PLAIN_VALUE = "text/plain";
    public static final MediaType TEXT_XML;
    public static final String TEXT_XML_VALUE = "text/xml";
    private static final String PARAM_QUALITY_FACTOR = "q";
    public static final Comparator<MediaType> QUALITY_VALUE_COMPARATOR;
    public static final Comparator<MediaType> SPECIFICITY_COMPARATOR;
    private static final String MIME_TYPES_FILE_NAME = "META-INF/mime.types";
    private static HashMap<String, MediaType> fileExtensionToMediaTypes;

    public MediaType(String type) {
        super(type);
    }

    public MediaType(String type, String subtype) {
        super(type, subtype, Collections.emptyMap());
    }

    public MediaType(String type, String subtype, Charset charset) {
        super(type, subtype, charset);
    }

    public MediaType(String type, String subtype, double qualityValue) {
        this(type, subtype, Collections.singletonMap(PARAM_QUALITY_FACTOR, Double.toString(qualityValue)));
    }

    public MediaType(MediaType other, Charset charset) {
        super((MimeType)other, charset);
    }

    public MediaType(MediaType other, Map<String, String> parameters) {
        super(other.getType(), other.getSubtype(), parameters);
    }

    public MediaType(String type, String subtype, Map<String, String> parameters) {
        super(type, subtype, parameters);
    }

    @Override
    protected void checkParameters(String attribute, String value) {
        double d;
        super.checkParameters(attribute, value);
        if (!(!PARAM_QUALITY_FACTOR.equals(attribute) || (d = Double.parseDouble(value = this.unquote(value))) >= 0.0 && d <= 1.0)) {
            throw new IllegalArgumentException("Invalid quality value \"" + value + "\": should be between 0.0 and 1.0");
        }
    }

    public double getQualityValue() {
        String qualityFactor = this.getParameter(PARAM_QUALITY_FACTOR);
        return qualityFactor != null ? Double.parseDouble(this.unquote(qualityFactor)) : 1.0;
    }

    public boolean includes(MediaType other) {
        return super.includes(other);
    }

    public boolean isCompatibleWith(MediaType other) {
        return super.isCompatibleWith(other);
    }

    public MediaType copyQualityValue(MediaType mediaType) {
        if (!mediaType.getParameters().containsKey(PARAM_QUALITY_FACTOR)) {
            return this;
        }
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>(this.getParameters());
        params.put(PARAM_QUALITY_FACTOR, mediaType.getParameters().get(PARAM_QUALITY_FACTOR));
        return new MediaType(this, params);
    }

    public MediaType removeQualityValue() {
        if (!this.getParameters().containsKey(PARAM_QUALITY_FACTOR)) {
            return this;
        }
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>(this.getParameters());
        params.remove(PARAM_QUALITY_FACTOR);
        return new MediaType(this, params);
    }

    public static MediaType valueOf(String value) {
        return MediaType.parseMediaType(value);
    }

    public static MediaType parseMediaType(String mediaType) {
        MimeType type;
        try {
            type = MimeTypeUtils.parseMimeType(mediaType);
        }
        catch (InvalidMimeTypeException ex) {
            throw new InvalidMediaTypeException(ex);
        }
        try {
            return new MediaType(type.getType(), type.getSubtype(), type.getParameters());
        }
        catch (IllegalArgumentException ex) {
            throw new InvalidMediaTypeException(mediaType, ex.getMessage());
        }
    }

    public static List<MediaType> parseMediaTypes(String mediaTypes) {
        if (StringUtils.isEmpty(mediaTypes)) {
            return Collections.emptyList();
        }
        List<String> tokenizedTypes = MimeTypeUtils.tokenize(mediaTypes);
        ArrayList<MediaType> result = new ArrayList<MediaType>(tokenizedTypes.size());
        for (String type : tokenizedTypes) {
            if (!StringUtils.isNotEmpty(type)) continue;
            result.add(MediaType.parseMediaType(type));
        }
        return result;
    }

    public static List<MediaType> parseMediaTypes(List<String> mediaTypes) {
        if (ObjectUtils.isEmpty(mediaTypes)) {
            return Collections.emptyList();
        }
        if (mediaTypes.size() == 1) {
            return MediaType.parseMediaTypes(mediaTypes.get(0));
        }
        ArrayList<MediaType> result = new ArrayList<MediaType>(8);
        for (String mediaType : mediaTypes) {
            result.addAll(MediaType.parseMediaTypes(mediaType));
        }
        return result;
    }

    public static List<MediaType> asMediaTypes(List<MimeType> mimeTypes) {
        ArrayList<MediaType> mediaTypes = new ArrayList<MediaType>(mimeTypes.size());
        for (MimeType mimeType : mimeTypes) {
            mediaTypes.add(MediaType.asMediaType(mimeType));
        }
        return mediaTypes;
    }

    public static MediaType asMediaType(MimeType mimeType) {
        return mimeType instanceof MediaType ? (MediaType)mimeType : new MediaType(mimeType.getType(), mimeType.getSubtype(), mimeType.getParameters());
    }

    public static String toString(Collection<MediaType> mediaTypes) {
        return MimeTypeUtils.toString(mediaTypes);
    }

    public static void sortBySpecificity(List<MediaType> mediaTypes) {
        if (Objects.requireNonNull(mediaTypes, "'mediaTypes' must not be null").size() > 1) {
            mediaTypes.sort(SPECIFICITY_COMPARATOR);
        }
    }

    public static void sortByQualityValue(List<MediaType> mediaTypes) {
        if (Objects.requireNonNull(mediaTypes, "'mediaTypes' must not be null").size() > 1) {
            mediaTypes.sort(QUALITY_VALUE_COMPARATOR);
        }
    }

    public static void sortBySpecificityAndQuality(List<MediaType> mediaTypes) {
        if (Objects.requireNonNull(mediaTypes, "'mediaTypes' must not be null").size() > 1) {
            mediaTypes.sort(SPECIFICITY_COMPARATOR.thenComparing(QUALITY_VALUE_COMPARATOR));
        }
    }

    /*
     * Exception decompiling
     */
    private static HashMap<String, MediaType> parseMimeTypes() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static MediaType of(Resource resource) {
        return resource == null ? null : MediaType.of(resource.getName());
    }

    public static MediaType of(String filename) {
        String ext = StringUtils.getFilenameExtension(filename);
        return ext == null ? null : MediaType.getFileExtensionMediaTypes().get(ext.toLowerCase(Locale.ENGLISH));
    }

    public static Map<String, MediaType> getFileExtensionMediaTypes() {
        return fileExtensionToMediaTypes == null ? (fileExtensionToMediaTypes = MediaType.parseMimeTypes()) : fileExtensionToMediaTypes;
    }

    static {
        TEXT_XML = new MediaType("text", "xml");
        TEXT_HTML = new MediaType("text", "html");
        IMAGE_PNG = new MediaType("image", "png");
        IMAGE_GIF = new MediaType("image", "gif");
        IMAGE_JPEG = new MediaType("image", "jpeg");
        TEXT_PLAIN = new MediaType("text", "plain");
        TEXT_MARKDOWN = new MediaType("text", "markdown");
        APPLICATION_XML = new MediaType("application", "xml");
        APPLICATION_PDF = new MediaType("application", "pdf");
        MULTIPART_MIXED = new MediaType("multipart", "mixed");
        APPLICATION_JSON = new MediaType("application", "json");
        APPLICATION_CBOR = new MediaType("application", "cbor");
        TEXT_EVENT_STREAM = new MediaType("text", "event-stream");
        MULTIPART_FORM_DATA = new MediaType("multipart", "form-data");
        APPLICATION_RSS_XML = new MediaType("application", "rss+xml");
        APPLICATION_ATOM_XML = new MediaType("application", "atom+xml");
        APPLICATION_XHTML_XML = new MediaType("application", "xhtml+xml");
        APPLICATION_PROBLEM_XML = new MediaType("application", "problem+xml");
        APPLICATION_STREAM_JSON = new MediaType("application", "stream+json");
        APPLICATION_PROBLEM_JSON = new MediaType("application", "problem+json");
        APPLICATION_OCTET_STREAM = new MediaType("application", "octet-stream");
        APPLICATION_FORM_URLENCODED = new MediaType("application", "x-www-form-urlencoded");
        APPLICATION_JSON_UTF8 = new MediaType("application", "json", Constant.DEFAULT_CHARSET);
        APPLICATION_PROBLEM_JSON_UTF8 = new MediaType("application", "problem+json", Constant.DEFAULT_CHARSET);
        QUALITY_VALUE_COMPARATOR = (mediaType1, mediaType2) -> {
            double quality1 = mediaType1.getQualityValue();
            double quality2 = mediaType2.getQualityValue();
            int qualityComparison = Double.compare(quality2, quality1);
            if (qualityComparison != 0) {
                return qualityComparison;
            }
            if (mediaType1.isWildcardType() && !mediaType2.isWildcardType()) {
                return 1;
            }
            if (mediaType2.isWildcardType() && !mediaType1.isWildcardType()) {
                return -1;
            }
            if (!mediaType1.getType().equals(mediaType2.getType())) {
                return 0;
            }
            if (mediaType1.isWildcardSubtype() && !mediaType2.isWildcardSubtype()) {
                return 1;
            }
            if (mediaType2.isWildcardSubtype() && !mediaType1.isWildcardSubtype()) {
                return -1;
            }
            if (!mediaType1.getSubtype().equals(mediaType2.getSubtype())) {
                return 0;
            }
            int paramsSize1 = mediaType1.getParameters().size();
            int paramsSize2 = mediaType2.getParameters().size();
            return Integer.compare(paramsSize2, paramsSize1);
        };
        SPECIFICITY_COMPARATOR = new MimeType.SpecificityComparator<MediaType>(){

            @Override
            protected int compareParameters(MediaType mediaType1, MediaType mediaType2) {
                double quality1 = mediaType1.getQualityValue();
                double quality2 = mediaType2.getQualityValue();
                int qualityComparison = Double.compare(quality2, quality1);
                if (qualityComparison != 0) {
                    return qualityComparison;
                }
                return super.compareParameters(mediaType1, mediaType2);
            }
        };
    }
}

