/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.utils;

import java.util.HashMap;

public class Mappings<V, T> {
    private final HashMap<Object, V> mapping;
    private volatile Function<V> mappingFunction;

    public Mappings() {
        this(new HashMap());
    }

    public Mappings(int initialCapacity) {
        this(new HashMap(initialCapacity));
    }

    public Mappings(HashMap<Object, V> mapping) {
        this.mapping = mapping;
    }

    public Mappings(Function<V> mappingFunction) {
        this(new HashMap(), mappingFunction);
    }

    public Mappings(HashMap<Object, V> mapping, Function<V> mappingFunction) {
        this.mapping = mapping;
        this.mappingFunction = mappingFunction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final V get(Object key, T param) {
        V value = this.mapping.get(key);
        if (value == null) {
            HashMap<Object, V> hashMap = this.mapping;
            synchronized (hashMap) {
                value = this.mapping.get(key);
                if (value == null) {
                    value = this.createValue(key, param);
                    this.mapping.put(key, value);
                }
            }
        }
        return value;
    }

    public final V get(Object key) {
        return this.get(key, (Function)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final V get(Object key, Function<V> mappingFunction) {
        V value = this.mapping.get(key);
        if (value == null) {
            HashMap<Object, V> hashMap = this.mapping;
            synchronized (hashMap) {
                value = this.mapping.get(key);
                if (value == null) {
                    if (mappingFunction == null) {
                        mappingFunction = this.mappingFunction;
                    }
                    if (mappingFunction != null) {
                        value = mappingFunction.apply(key);
                        this.mapping.put(key, value);
                    }
                }
            }
        }
        return value;
    }

    protected V createValue(Object key, T param) {
        return null;
    }

    public synchronized void setMappingFunction(Function<V> mappingFunction) {
        this.mappingFunction = mappingFunction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V put(Object key, V value) {
        HashMap<Object, V> hashMap = this.mapping;
        synchronized (hashMap) {
            return this.mapping.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        HashMap<Object, V> hashMap = this.mapping;
        synchronized (hashMap) {
            this.mapping.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V remove(Object key) {
        HashMap<Object, V> hashMap = this.mapping;
        synchronized (hashMap) {
            return this.mapping.remove(key);
        }
    }

    @FunctionalInterface
    public static interface Function<R> {
        public R apply(Object var1);
    }
}

