/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.utils;

import cn.taketoday.context.factory.BeanProperty;
import cn.taketoday.context.utils.Assert;
import cn.taketoday.context.utils.ClassUtils;
import cn.taketoday.context.utils.CollectionUtils;
import cn.taketoday.context.utils.ResolvableType;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Parameter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;

public class GenericDescriptor
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Map<Class<?>, GenericDescriptor> commonTypesCache = new HashMap(32);
    private static final Class<?>[] CACHED_COMMON_TYPES;
    private final Class<?> type;
    private final ResolvableType resolvableType;
    private final AnnotatedElement annotatedElement;

    public GenericDescriptor(Field field) {
        this.annotatedElement = field;
        this.resolvableType = ResolvableType.forField(field);
        this.type = this.resolvableType.resolve(field.getType());
    }

    public GenericDescriptor(BeanProperty property) {
        this.type = property.getType();
        this.annotatedElement = property;
        this.resolvableType = ResolvableType.forField(property.getField());
    }

    public GenericDescriptor(ResolvableType resolvableType, Class<?> type, Annotation[] annotations) {
        this.resolvableType = resolvableType;
        this.type = type != null ? type : resolvableType.toClass();
        this.annotatedElement = new AnnotatedElementAdapter(annotations);
    }

    public GenericDescriptor(ResolvableType resolvableType, Class<?> type, AnnotatedElement annotated) {
        this.annotatedElement = annotated;
        this.resolvableType = resolvableType;
        this.type = type != null ? type : resolvableType.toClass();
    }

    public Class<?> getType() {
        return this.type;
    }

    public boolean isArray() {
        return this.type.isArray();
    }

    public boolean isCollection() {
        return CollectionUtils.isCollection(this.type);
    }

    public Class<?> getComponentType() {
        return this.type.getComponentType();
    }

    public boolean isInstance(Object source) {
        return this.type.isInstance(source);
    }

    public boolean is(Class<?> testClass) {
        return this.type == testClass;
    }

    public boolean isAssignableFrom(Class<?> subType) {
        return this.type.isAssignableFrom(subType);
    }

    public boolean isAssignableTo(Class<?> superType) {
        return superType.isAssignableFrom(this.type);
    }

    public boolean isEnum() {
        return this.type.isEnum();
    }

    public Object getName() {
        return ClassUtils.getQualifiedName(this.getType());
    }

    public String getSimpleName() {
        return this.type.getSimpleName();
    }

    public GenericDescriptor getGeneric(Class<?> genericIfc) {
        ResolvableType generic = this.resolvableType.as(genericIfc).getGeneric(0);
        return GenericDescriptor.getRelatedIfResolvable(this, generic);
    }

    public ResolvableType getResolvableType() {
        return this.resolvableType;
    }

    public Object getSource() {
        return this.resolvableType.getSource();
    }

    public GenericDescriptor narrow(Object value) {
        if (value == null) {
            return this;
        }
        ResolvableType narrowed = ResolvableType.forType(value.getClass(), this.getResolvableType());
        return new GenericDescriptor(narrowed, value.getClass(), this.getAnnotations());
    }

    public GenericDescriptor upcast(Class<?> superType) {
        if (superType == null) {
            return null;
        }
        Assert.isAssignable(superType, this.getType());
        return new GenericDescriptor(this.getResolvableType().as(superType), superType, this.getAnnotations());
    }

    public boolean isPrimitive() {
        return this.getType().isPrimitive();
    }

    public Annotation[] getAnnotations() {
        return this.annotatedElement.getAnnotations();
    }

    public boolean hasAnnotation(Class<? extends Annotation> annotationType) {
        return ClassUtils.isAnnotationPresent(this.annotatedElement, annotationType);
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
        return ClassUtils.getAnnotation(annotationType, this.annotatedElement);
    }

    public boolean isAssignableTo(GenericDescriptor genericDescriptor) {
        boolean typesAssignable = genericDescriptor.getType().isAssignableFrom(this.getType());
        if (!typesAssignable) {
            return false;
        }
        if (this.isArray() && genericDescriptor.isArray()) {
            return this.isNestedAssignable(this.getElementDescriptor(), genericDescriptor.getElementDescriptor());
        }
        if (this.isCollection() && genericDescriptor.isCollection()) {
            return this.isNestedAssignable(this.getElementDescriptor(), genericDescriptor.getElementDescriptor());
        }
        if (this.isMap() && genericDescriptor.isMap()) {
            return this.isNestedAssignable(this.getMapKeyGenericDescriptor(), genericDescriptor.getMapKeyGenericDescriptor()) && this.isNestedAssignable(this.getMapValueGenericDescriptor(), genericDescriptor.getMapValueGenericDescriptor());
        }
        return true;
    }

    private boolean isNestedAssignable(GenericDescriptor nestedGenericDescriptor, GenericDescriptor otherNestedGenericDescriptor) {
        return nestedGenericDescriptor == null || otherNestedGenericDescriptor == null || nestedGenericDescriptor.isAssignableTo(otherNestedGenericDescriptor);
    }

    public GenericDescriptor getElementDescriptor() {
        if (this.getResolvableType().isArray()) {
            return new GenericDescriptor(this.getResolvableType().getComponentType(), null, this.getAnnotations());
        }
        if (Stream.class.isAssignableFrom(this.getType())) {
            return GenericDescriptor.getRelatedIfResolvable(this, this.getResolvableType().as(Stream.class).getGeneric(0));
        }
        return GenericDescriptor.getRelatedIfResolvable(this, this.getResolvableType().asCollection().getGeneric(0));
    }

    public GenericDescriptor elementGenericDescriptor(Object element) {
        return this.narrow(element, this.getElementDescriptor());
    }

    public boolean isMap() {
        return Map.class.isAssignableFrom(this.getType());
    }

    public GenericDescriptor getMapKeyGenericDescriptor() {
        Assert.state(this.isMap(), "Not a [java.util.Map]");
        return GenericDescriptor.getRelatedIfResolvable(this, this.getResolvableType().asMap().getGeneric(0));
    }

    public GenericDescriptor getMapKeyGenericDescriptor(Object mapKey) {
        return this.narrow(mapKey, this.getMapKeyGenericDescriptor());
    }

    public GenericDescriptor getMapValueGenericDescriptor() {
        Assert.state(this.isMap(), "Not a [java.util.Map]");
        return GenericDescriptor.getRelatedIfResolvable(this, this.getResolvableType().asMap().getGeneric(1));
    }

    public GenericDescriptor getMapValueGenericDescriptor(Object mapValue) {
        return this.narrow(mapValue, this.getMapValueGenericDescriptor());
    }

    private GenericDescriptor narrow(Object value, GenericDescriptor genericDescriptor) {
        if (genericDescriptor != null) {
            return genericDescriptor.narrow(value);
        }
        if (value != null) {
            return this.narrow(value);
        }
        return null;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GenericDescriptor)) {
            return false;
        }
        GenericDescriptor otherDesc = (GenericDescriptor)other;
        if (this.getType() != otherDesc.getType()) {
            return false;
        }
        if (!this.annotationsMatch(otherDesc)) {
            return false;
        }
        if (this.isCollection() || this.isArray()) {
            return Objects.equals(this.getElementDescriptor(), otherDesc.getElementDescriptor());
        }
        if (this.isMap()) {
            return Objects.equals(this.getMapKeyGenericDescriptor(), otherDesc.getMapKeyGenericDescriptor()) && Objects.equals(this.getMapValueGenericDescriptor(), otherDesc.getMapValueGenericDescriptor());
        }
        return true;
    }

    private boolean annotationsMatch(GenericDescriptor otherDesc) {
        Annotation[] otherAnns;
        Annotation[] anns = this.getAnnotations();
        if (anns == (otherAnns = otherDesc.getAnnotations())) {
            return true;
        }
        if (anns.length != otherAnns.length) {
            return false;
        }
        if (anns.length > 0) {
            for (int i = 0; i < anns.length; ++i) {
                if (this.annotationEquals(anns[i], otherAnns[i])) continue;
                return false;
            }
        }
        return true;
    }

    private boolean annotationEquals(Annotation ann, Annotation otherAnn) {
        return ann == otherAnn || ann.getClass() == otherAnn.getClass() && ann.equals(otherAnn);
    }

    public int hashCode() {
        return this.getType().hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Annotation ann : this.getAnnotations()) {
            builder.append("@").append(ann.annotationType().getName()).append(' ');
        }
        builder.append(this.getResolvableType());
        return builder.toString();
    }

    public static GenericDescriptor forObject(Object source) {
        return source != null ? GenericDescriptor.valueOf(source.getClass()) : null;
    }

    public static GenericDescriptor valueOf(Class<?> type) {
        GenericDescriptor desc;
        if (type == null) {
            type = Object.class;
        }
        return (desc = commonTypesCache.get(type)) != null ? desc : new GenericDescriptor(ResolvableType.forClass(type), null, (Annotation[])null);
    }

    public static GenericDescriptor collection(Class<?> collectionType, Class<?> element) {
        return GenericDescriptor.collection(collectionType, GenericDescriptor.valueOf(element));
    }

    public static GenericDescriptor collection(Class<?> collectionType, GenericDescriptor elementDescriptor) {
        Assert.notNull(collectionType, "Collection type must not be null");
        if (!Collection.class.isAssignableFrom(collectionType)) {
            throw new IllegalArgumentException("Collection type must be a [java.util.Collection]");
        }
        ResolvableType element = elementDescriptor != null ? elementDescriptor.resolvableType : null;
        return new GenericDescriptor(ResolvableType.forClassWithGenerics(collectionType, element), null, (Annotation[])null);
    }

    public static GenericDescriptor map(Class<?> mapType, Class<?> key, Class<?> value) {
        return GenericDescriptor.map(mapType, GenericDescriptor.valueOf(key), GenericDescriptor.valueOf(value));
    }

    public static GenericDescriptor map(Class<?> mapType, GenericDescriptor keyDescriptor, GenericDescriptor valueDescriptor) {
        Assert.notNull(mapType, "Map type must not be null");
        if (!Map.class.isAssignableFrom(mapType)) {
            throw new IllegalArgumentException("Map type must be a [java.util.Map]");
        }
        ResolvableType key = keyDescriptor != null ? keyDescriptor.resolvableType : null;
        ResolvableType value = valueDescriptor != null ? valueDescriptor.resolvableType : null;
        return new GenericDescriptor(ResolvableType.forClassWithGenerics(mapType, key, value), null, (Annotation[])null);
    }

    public static GenericDescriptor array(GenericDescriptor elementDescriptor) {
        if (elementDescriptor == null) {
            return null;
        }
        return new GenericDescriptor(ResolvableType.forArrayComponent(elementDescriptor.resolvableType), null, elementDescriptor.getAnnotations());
    }

    public static GenericDescriptor nested(Field field, int nestingLevel) {
        return GenericDescriptor.nested(new GenericDescriptor(field), nestingLevel);
    }

    public static GenericDescriptor nested(GenericDescriptor genericDescriptor, int nestingLevel) {
        ResolvableType nested = genericDescriptor.resolvableType;
        for (int i = 0; i < nestingLevel; ++i) {
            if (Object.class == nested.getType()) continue;
            nested = nested.getNested(2);
        }
        if (nested == ResolvableType.NONE) {
            return null;
        }
        return GenericDescriptor.getRelatedIfResolvable(genericDescriptor, nested);
    }

    private static GenericDescriptor getRelatedIfResolvable(GenericDescriptor source, ResolvableType type) {
        if (type.resolve() == null) {
            return null;
        }
        return new GenericDescriptor(type, null, source.getAnnotations());
    }

    public static GenericDescriptor ofProperty(Field beanProperty) {
        return new GenericDescriptor(beanProperty);
    }

    public static GenericDescriptor ofProperty(BeanProperty beanProperty) {
        return new GenericDescriptor(beanProperty);
    }

    public static GenericDescriptor ofParameter(Executable executable, int parameterIndex) {
        Parameter parameter = ClassUtils.getParameter(executable, parameterIndex);
        ResolvableType resolvableType = ResolvableType.forParameter(parameter);
        Class<?> type = parameter.getType();
        return new GenericDescriptor(resolvableType, type, parameter);
    }

    static {
        for (Class<?> preCachedClass : CACHED_COMMON_TYPES = new Class[]{Boolean.TYPE, Boolean.class, Byte.TYPE, Byte.class, Character.TYPE, Character.class, Double.TYPE, Double.class, Float.TYPE, Float.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Short.TYPE, Short.class, String.class, Object.class}) {
            commonTypesCache.put(preCachedClass, GenericDescriptor.valueOf(preCachedClass));
        }
    }

    class AnnotatedElementAdapter
    extends cn.taketoday.context.utils.AnnotatedElementAdapter {
        public AnnotatedElementAdapter(Annotation[] annotations) {
            super(annotations);
        }

        public String toString() {
            return GenericDescriptor.this.toString();
        }
    }
}

