/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.utils;

import cn.taketoday.context.utils.Assert;
import cn.taketoday.context.utils.CollectionUtils;
import cn.taketoday.context.utils.MultiValueMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.IntFunction;

public class DefaultMultiValueMap<K, V>
implements MultiValueMap<K, V>,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    static final Function default_mapping_function = new Function(){

        public Object apply(Object k) {
            return new LinkedList();
        }
    };
    private final Map<K, List<V>> map;
    private final Function<K, List<V>> mappingFunction;

    public DefaultMultiValueMap() {
        this(new HashMap());
    }

    public DefaultMultiValueMap(Function<K, List<V>> mappingFunction) {
        this.map = new HashMap<K, List<V>>();
        this.mappingFunction = mappingFunction;
    }

    public DefaultMultiValueMap(int initialCapacity) {
        this(new HashMap(initialCapacity));
    }

    public DefaultMultiValueMap(int initialCapacity, float loadFactor) {
        this(initialCapacity, loadFactor, default_mapping_function);
    }

    public DefaultMultiValueMap(int initialCapacity, float loadFactor, Function<K, List<V>> mappingFunction) {
        this.map = new HashMap<K, List<V>>(initialCapacity, loadFactor);
        this.mappingFunction = mappingFunction;
    }

    public DefaultMultiValueMap(Map<K, List<V>> map) {
        this(map, false);
    }

    public DefaultMultiValueMap(Map<K, List<V>> map, boolean copy) {
        this(map, copy, default_mapping_function);
    }

    public DefaultMultiValueMap(Map<K, List<V>> map, boolean copy, Function<K, List<V>> mappingFunction) {
        this.map = copy ? new HashMap(map) : map;
        this.mappingFunction = mappingFunction;
    }

    @Override
    public V getFirst(K key) {
        List<V> values = this.map.get(key);
        return values != null && !values.isEmpty() ? (V)values.get(0) : null;
    }

    @Override
    public void add(K key, V value) {
        List<V> values = this.map.computeIfAbsent(key, this.mappingFunction);
        values.add(value);
    }

    @Override
    public void addAll(K key, List<? extends V> values) {
        List<V> currentValues = this.map.computeIfAbsent(key, this.mappingFunction);
        currentValues.addAll(values);
    }

    @Override
    public void addAll(MultiValueMap<K, V> values) {
        for (Map.Entry entry : values.entrySet()) {
            this.addAll(entry.getKey(), (List)entry.getValue());
        }
    }

    @Override
    public void set(K key, V value) {
        List<V> values = this.mappingFunction.apply(key);
        values.add(value);
        this.map.put(key, values);
    }

    @Override
    public void setAll(Map<K, V> values) {
        values.forEach(this::set);
    }

    @Override
    public Map<K, V> toSingleValueMap() {
        HashMap<K, V> singleValueMap = new HashMap<K, V>(this.map.size());
        for (Map.Entry<K, List<V>> entry : this.map.entrySet()) {
            List<V> values = entry.getValue();
            if (CollectionUtils.isEmpty(values)) continue;
            singleValueMap.put(entry.getKey(), values.get(0));
        }
        return singleValueMap;
    }

    @Override
    public Map<K, V[]> toArrayMap(IntFunction<V[]> function) {
        HashMap singleValueMap = new HashMap(this.map.size());
        this.copyToArrayMap(singleValueMap, function);
        return singleValueMap;
    }

    @Override
    public void copyToArrayMap(Map<K, V[]> newMap, IntFunction<V[]> mappingFunction) {
        Assert.notNull(newMap, "newMap must not be null");
        Assert.notNull(mappingFunction, "mappingFunction must not be null");
        for (Map.Entry<K, List<V>> entry : this.map.entrySet()) {
            List<V> values = entry.getValue();
            if (CollectionUtils.isEmpty(values)) continue;
            V[] toArray = values.toArray(mappingFunction.apply(values.size()));
            newMap.put(entry.getKey(), (V[][])toArray);
        }
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public List<V> get(Object key) {
        return this.map.get(key);
    }

    @Override
    public List<V> put(K key, List<V> value) {
        return this.map.put(key, value);
    }

    @Override
    public List<V> remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends List<V>> map) {
        this.map.putAll(map);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<List<V>> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<K, List<V>>> entrySet() {
        return this.map.entrySet();
    }

    public DefaultMultiValueMap<K, V> deepCopy() {
        DefaultMultiValueMap<K, V> ret = new DefaultMultiValueMap<K, V>(this.map.size());
        Function<K, List<V>> mappingFunction = this.mappingFunction;
        for (Map.Entry<K, List<V>> entry : this.map.entrySet()) {
            K key = entry.getKey();
            List<V> value = entry.getValue();
            List<V> apply = mappingFunction.apply(key);
            apply.addAll(value);
            ret.put(key, apply);
        }
        return ret;
    }

    public DefaultMultiValueMap<K, V> clone() {
        return new DefaultMultiValueMap<K, V>(this, true);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof DefaultMultiValueMap) {
            return this.map.equals(((DefaultMultiValueMap)obj).map);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return this.map.toString();
    }
}

