/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.utils;

import cn.taketoday.context.AnnotationAttributes;
import cn.taketoday.context.ApplicationContext;
import cn.taketoday.context.ConcurrentProperties;
import cn.taketoday.context.Condition;
import cn.taketoday.context.Constant;
import cn.taketoday.context.ExpressionEvaluator;
import cn.taketoday.context.annotation.Component;
import cn.taketoday.context.annotation.Conditional;
import cn.taketoday.context.annotation.DefaultProps;
import cn.taketoday.context.annotation.Env;
import cn.taketoday.context.annotation.Props;
import cn.taketoday.context.annotation.Value;
import cn.taketoday.context.env.Environment;
import cn.taketoday.context.exception.ConfigurationException;
import cn.taketoday.context.exception.ContextException;
import cn.taketoday.context.factory.BeanDefinition;
import cn.taketoday.context.factory.BeanFactory;
import cn.taketoday.context.factory.BeanPostProcessor;
import cn.taketoday.context.factory.DefaultPropertySetter;
import cn.taketoday.context.factory.DestructionBeanPostProcessor;
import cn.taketoday.context.factory.DisposableBean;
import cn.taketoday.context.factory.PropertySetter;
import cn.taketoday.context.factory.StandardBeanDefinition;
import cn.taketoday.context.loader.ArrayParameterResolver;
import cn.taketoday.context.loader.AutowiredParameterResolver;
import cn.taketoday.context.loader.AutowiredPropertyResolver;
import cn.taketoday.context.loader.BeanDefinitionLoader;
import cn.taketoday.context.loader.CollectionParameterResolver;
import cn.taketoday.context.loader.ExecutableParameterResolver;
import cn.taketoday.context.loader.MapParameterResolver;
import cn.taketoday.context.loader.ObjectSupplierParameterResolver;
import cn.taketoday.context.logger.Logger;
import cn.taketoday.context.logger.LoggerFactory;
import cn.taketoday.context.utils.Assert;
import cn.taketoday.context.utils.ClassUtils;
import cn.taketoday.context.utils.CollectionUtils;
import cn.taketoday.context.utils.ConvertUtils;
import cn.taketoday.context.utils.ObjectUtils;
import cn.taketoday.context.utils.OrderUtils;
import cn.taketoday.context.utils.ReflectionUtils;
import cn.taketoday.context.utils.ResourceUtils;
import cn.taketoday.context.utils.StringUtils;
import cn.taketoday.expression.ExpressionProcessor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;

public abstract class ContextUtils {
    private static final Logger log = LoggerFactory.getLogger(ContextUtils.class);
    private static ApplicationContext lastStartupContext;
    private static ExecutableParameterResolver[] parameterResolvers;
    private static ExpressionEvaluator expressionEvaluator;

    public static ApplicationContext getLastStartupContext() {
        return lastStartupContext;
    }

    public static void setLastStartupContext(ApplicationContext lastStartupContext) {
        ContextUtils.lastStartupContext = lastStartupContext;
        expressionEvaluator = new ExpressionEvaluator(lastStartupContext);
    }

    public static void setExpressionEvaluator(ExpressionEvaluator expressionEvaluator) {
        Assert.notNull((Object)expressionEvaluator, "ExpressionEvaluator must not be null");
        ContextUtils.expressionEvaluator = expressionEvaluator;
    }

    public static ExpressionEvaluator getExpressionEvaluator() {
        return expressionEvaluator;
    }

    public static ExpressionProcessor getExpressionProcessor() {
        ApplicationContext ctx = ContextUtils.getLastStartupContext();
        Assert.state(ctx != null, "There isn't a ApplicationContext");
        return ctx.getEnvironment().getExpressionProcessor();
    }

    public static String[] findNames(String defaultName, String ... names) {
        if (StringUtils.isArrayEmpty(names)) {
            return new String[]{defaultName};
        }
        return names;
    }

    public static <T> T resolveValue(String expression, Class<T> expectedType, Properties variables) {
        return expressionEvaluator.evaluate(expression, expectedType, variables);
    }

    public static InputStream getResourceAsStream(String resource) throws IOException {
        InputStream in = ResourceUtils.getResource(resource).getInputStream();
        if (in == null) {
            throw new IOException("Could not find resource " + resource);
        }
        return in;
    }

    public static Properties getResourceAsProperties(String resource) throws IOException {
        ConcurrentProperties props = new ConcurrentProperties();
        try (InputStream in = ResourceUtils.getResource(StringUtils.checkPropertiesName(resource)).getInputStream();){
            props.load(in);
        }
        return props;
    }

    public static InputStream getUrlAsStream(String urlString) throws IOException {
        return new URL(urlString).openConnection().getInputStream();
    }

    public static Properties getUrlAsProperties(String urlString) throws IOException {
        ConcurrentProperties props = new ConcurrentProperties();
        try (InputStream in = ContextUtils.getUrlAsStream(StringUtils.checkPropertiesName(urlString));){
            props.load(in);
        }
        return props;
    }

    public static String resolvePlaceholder(Map<Object, Object> properties, String value) {
        return ContextUtils.resolvePlaceholder(properties, value, true);
    }

    public static String resolvePlaceholder(Map<Object, Object> properties, String input, boolean throw_) {
        return expressionEvaluator.resolvePlaceholder(properties, input, throw_);
    }

    public static void resolveInitMethod(BeanDefinition def, String ... initMethods) {
        def.setInitMethods(ContextUtils.resolveInitMethod(initMethods, def.getBeanClass()));
    }

    public static Method[] resolveInitMethod(Class<?> beanClass, String ... initMethods) {
        return ContextUtils.resolveInitMethod(initMethods, beanClass);
    }

    public static Method[] resolveInitMethod(String[] initMethods, Class<?> beanClass) {
        ArrayList<Method> methods = new ArrayList<Method>(2);
        do {
            ContextUtils.addInitMethod(methods, beanClass, initMethods);
        } while ((beanClass = beanClass.getSuperclass()) != null && beanClass != Object.class);
        if (methods.isEmpty()) {
            return BeanDefinition.EMPTY_METHOD;
        }
        OrderUtils.reversedSort(methods);
        return methods.toArray(new Method[methods.size()]);
    }

    private static void addInitMethod(List<Method> methods, Class<?> beanClass, String[] initMethods) {
        boolean initMethodsNotEmpty = StringUtils.isArrayNotEmpty(initMethods);
        for (Method method : ReflectionUtils.getDeclaredMethods(beanClass)) {
            if (ClassUtils.isAnnotationPresent(method, PostConstruct.class) || AutowiredPropertyResolver.isInjectable(method)) {
                methods.add(method);
                continue;
            }
            if (!initMethodsNotEmpty) continue;
            String name = method.getName();
            for (String initMethod : initMethods) {
                if (!initMethod.equals(name)) continue;
                methods.add(method);
            }
        }
    }

    public static void resolveProps(BeanDefinition def, Environment env) {
        def.addPropertySetter(ContextUtils.resolveProps((AnnotatedElement)def, env.getProperties()));
    }

    public static List<PropertySetter> resolveProps(AnnotatedElement annotated, Properties properties) {
        Assert.notNull((Object)annotated, "AnnotatedElement must not be null");
        Props props = annotated.getAnnotation(Props.class);
        if (props == null) {
            return Collections.emptyList();
        }
        Class<?> type = ContextUtils.getBeanClass(annotated);
        if (log.isDebugEnabled()) {
            log.debug("Loading Properties For: [{}]", (Object)type.getName());
        }
        ArrayList<PropertySetter> propertySetters = new ArrayList<PropertySetter>();
        String[] prefixs = props.prefix();
        List<Class<?>> nested = Arrays.asList(props.nested());
        for (Field declaredField : ReflectionUtils.getFields(type)) {
            Object converted = ContextUtils.resolveProps(declaredField, nested, prefixs, properties);
            if (converted == null) continue;
            propertySetters.add(new DefaultPropertySetter(converted, ReflectionUtils.makeAccessible(declaredField)));
        }
        return propertySetters;
    }

    public static Class<?> getBeanClass(AnnotatedElement annotated) {
        if (annotated instanceof Class) {
            return (Class)annotated;
        }
        if (annotated instanceof BeanDefinition) {
            return ((BeanDefinition)annotated).getBeanClass();
        }
        if (annotated instanceof Method) {
            return ((Method)annotated).getReturnType();
        }
        throw new ConfigurationException("Not support annotated element: [" + annotated + "]");
    }

    public static Object resolveProps(Field declaredField, List<Class<?>> nested, String[] prefixs, Properties properties) {
        Class<?> fieldType = declaredField.getType();
        boolean debugEnabled = log.isDebugEnabled();
        for (String prefix : prefixs) {
            String key = prefix.concat(declaredField.getName());
            Class<?> value = properties.get(key);
            if (value == null) {
                DefaultProps nestedProps;
                if (declaredField.isAnnotationPresent(Props.class)) {
                    nestedProps = new DefaultProps(declaredField.getAnnotation(Props.class));
                } else {
                    if (!nested.contains(fieldType)) continue;
                    nestedProps = new DefaultProps();
                }
                boolean replace = nestedProps.replace();
                String[] prefixsToUse = nestedProps.prefix();
                for (int i = 0; i < prefixsToUse.length; ++i) {
                    String str = prefixsToUse[i];
                    if (StringUtils.isEmpty(str)) {
                        prefixsToUse[i] = key.concat(".");
                        continue;
                    }
                    if (replace) continue;
                    prefixsToUse[i] = prefix.concat(str);
                }
                value = ContextUtils.resolveProps((Props)nestedProps.setPrefix(prefixsToUse), fieldType, properties);
            }
            if (debugEnabled) {
                log.debug("Found Property: [{}] = [{}]", (Object)key, (Object)value);
            }
            if (value instanceof String) {
                return ContextUtils.resolveValue((String)((Object)value), fieldType, properties);
            }
            if (value == null) continue;
            return ConvertUtils.convert((Object)value, fieldType);
        }
        return null;
    }

    public static <T> T resolveProps(Props props, Class<T> beanClass, Properties properties) {
        return ContextUtils.resolveProps(props, ClassUtils.newInstance(beanClass), properties);
    }

    public static <T> T resolveProps(Props props, T bean, Properties properties) {
        String[] prefixs = props.prefix();
        List<Class<?>> nested = Arrays.asList(props.nested());
        for (Field declaredField : ReflectionUtils.getFields(bean)) {
            Object converted = ContextUtils.resolveProps(declaredField, nested, prefixs, properties);
            if (converted == null) continue;
            ReflectionUtils.setField(ReflectionUtils.makeAccessible(declaredField), bean, converted);
        }
        return bean;
    }

    public static Properties loadProps(Props props, Properties applicationProps) {
        Properties propertiesToUse;
        ConcurrentProperties ret = new ConcurrentProperties();
        String[] fileNames = props.value();
        if (fileNames.length == 0) {
            Assert.notNull((Object)applicationProps, "Application properties must not be null");
            propertiesToUse = applicationProps;
        } else {
            propertiesToUse = new ConcurrentProperties();
            for (String fileName : fileNames) {
                if (StringUtils.isEmpty(fileName)) {
                    propertiesToUse.putAll((Map<?, ?>)applicationProps);
                    break;
                }
                try (InputStream inputStream = ContextUtils.getResourceAsStream(StringUtils.checkPropertiesName(fileName));){
                    propertiesToUse.load(inputStream);
                }
                catch (IOException e) {
                    throw new ContextException("IO exception occurred", e);
                }
            }
        }
        String[] prefixs = props.prefix();
        boolean replace = props.replace();
        for (Map.Entry<Object, Object> entry : propertiesToUse.entrySet()) {
            Object key_ = entry.getKey();
            if (!(key_ instanceof String)) continue;
            String key = (String)key_;
            String blank = "";
            for (String prefix : prefixs) {
                Object value;
                if (!"".equals(prefix) && !key.startsWith(prefix)) continue;
                if (replace) {
                    key = key.replaceFirst(prefix, "");
                }
                if ((value = entry.getValue()) instanceof String) {
                    ((Properties)ret).put(key, ContextUtils.resolveValue((String)value, Object.class, propertiesToUse));
                    continue;
                }
                ((Properties)ret).put(key, value);
            }
        }
        return ret;
    }

    public static boolean passCondition(AnnotatedElement annotated) {
        return ContextUtils.passCondition(annotated, ContextUtils.getLastStartupContext());
    }

    public static boolean passCondition(AnnotatedElement annotated, ApplicationContext context) {
        Object[] attributes = ClassUtils.getAnnotationAttributesArray(annotated, Conditional.class);
        if (ObjectUtils.isEmpty(attributes)) {
            return true;
        }
        if (attributes.length == 1) {
            return ContextUtils.passCondition(annotated, context, ((AnnotationAttributes)attributes[0]).getClassArray("value"));
        }
        for (AnnotationAttributes conditional : (AnnotationAttributes[])OrderUtils.reversedSort(attributes)) {
            if (ContextUtils.passCondition(annotated, context, conditional.getClassArray("value"))) continue;
            return false;
        }
        return true;
    }

    public static boolean passCondition(AnnotatedElement annotated, ApplicationContext context, Class<? extends Condition>[] condition) {
        Assert.notNull(condition, "Condition Class must not be null");
        for (Class<? extends Condition> conditionClass : condition) {
            if (ClassUtils.newInstance(conditionClass, (BeanFactory)context).matches(context, annotated)) continue;
            return false;
        }
        return true;
    }

    public static void validateBeanDefinition(BeanDefinition def) {
        if (def instanceof StandardBeanDefinition) {
            StandardBeanDefinition standardDef = (StandardBeanDefinition)def;
            if (StringUtils.isEmpty(standardDef.getDeclaringName())) {
                throw new ConfigurationException("Declaring name can't be null in: " + standardDef);
            }
            ConfigurationException.nonNull(standardDef.getFactoryMethod(), "Factory Method can't be null");
        }
        ConfigurationException.nonNull(def.getName(), "Definition's bean name can't be null");
        ConfigurationException.nonNull(def.getBeanClass(), "Definition's bean class can't be null");
        if (def.getDestroyMethods() == null) {
            def.setDestroyMethods(Constant.EMPTY_STRING_ARRAY);
        }
        if (def.getInitMethods() == null) {
            def.setInitMethods(ContextUtils.resolveInitMethod(null, def.getBeanClass()));
        }
    }

    public static void destroyBean(Object obj) throws Exception {
        ContextUtils.destroyBean(obj, null);
    }

    public static void destroyBean(Object obj, BeanDefinition def) throws Exception {
        ContextUtils.destroyBean(obj, def, null);
    }

    public static void destroyBean(Object obj, BeanDefinition def, List<BeanPostProcessor> postProcessors) throws Exception {
        Assert.notNull(obj, "bean instance must not be null");
        if (!CollectionUtils.isEmpty(postProcessors)) {
            for (BeanPostProcessor postProcessor : postProcessors) {
                DestructionBeanPostProcessor destruction;
                if (!(postProcessor instanceof DestructionBeanPostProcessor) || !(destruction = (DestructionBeanPostProcessor)postProcessor).requiresDestruction(obj)) continue;
                destruction.postProcessBeforeDestruction(obj, def);
            }
        }
        Class<Object> beanClass = ClassUtils.getUserClass(obj);
        List<String> destroyMethods = def != null ? Arrays.asList(def.getDestroyMethods()) : null;
        for (Method method : ReflectionUtils.getDeclaredMethods(beanClass)) {
            if ((destroyMethods == null || !destroyMethods.contains(method.getName())) && !method.isAnnotationPresent(PreDestroy.class) || method.getParameterCount() != 0) continue;
            ReflectionUtils.makeAccessible(method).invoke(obj, new Object[0]);
        }
        if (obj instanceof DisposableBean) {
            ((DisposableBean)obj).destroy();
        }
    }

    public static List<BeanDefinition> createBeanDefinitions(String defaultName, Class<?> beanClass) {
        return ContextUtils.createBeanDefinitions(defaultName, beanClass, ContextUtils.getLastStartupContext());
    }

    public static List<BeanDefinition> createBeanDefinitions(String defaultName, Class<?> beanClass, ApplicationContext context) {
        return ContextUtils.createBeanDefinitions(defaultName, beanClass, context.getEnvironment().getBeanDefinitionLoader());
    }

    public static List<BeanDefinition> createBeanDefinitions(String defaultName, Class<?> beanClass, BeanDefinitionLoader beanDefinitionLoader) {
        Object[] componentAttributes = ClassUtils.getAnnotationAttributesArray(beanClass, Component.class);
        if (ObjectUtils.isEmpty(componentAttributes)) {
            return Collections.singletonList(beanDefinitionLoader.createBeanDefinition(defaultName, beanClass));
        }
        ArrayList<BeanDefinition> ret = new ArrayList<BeanDefinition>(componentAttributes.length);
        for (Object attributes : componentAttributes) {
            for (String name : ContextUtils.findNames(defaultName, ((AnnotationAttributes)attributes).getStringArray("value"))) {
                ret.add(beanDefinitionLoader.createBeanDefinition(name, beanClass, (AnnotationAttributes)attributes));
            }
        }
        return ret;
    }

    public static BeanDefinition createBeanDefinition(String beanName, Class<?> beanClass) {
        return ContextUtils.createBeanDefinition(beanName, beanClass, ContextUtils.getLastStartupContext());
    }

    public static BeanDefinition createBeanDefinition(String beanName, Class<?> beanClass, ApplicationContext ctx) {
        return ContextUtils.createBeanDefinition(beanName, beanClass, null, ctx);
    }

    public static BeanDefinition createBeanDefinition(String name, Class<?> bean, AnnotationAttributes attributes) {
        return ContextUtils.createBeanDefinition(name, bean, attributes, ContextUtils.getLastStartupContext());
    }

    public static BeanDefinition createBeanDefinition(String beanName, Class<?> beanClass, AnnotationAttributes attributes, ApplicationContext applicationContext) {
        Assert.notNull((Object)applicationContext, "ApplicationContext must not be null");
        return applicationContext.getEnvironment().getBeanDefinitionLoader().createBeanDefinition(beanName, beanClass, attributes);
    }

    public static Set<Class<?>> loadFromMetaInfo(String resource) {
        Assert.notNull((Object)resource, "META-INF resource must not be null");
        if (resource.startsWith("META-INF")) {
            HashSet ret = new HashSet();
            ClassLoader classLoader = ClassUtils.getClassLoader();
            Charset charset = Constant.DEFAULT_CHARSET;
            try {
                Enumeration<URL> resources = classLoader.getResources(resource);
                while (resources.hasMoreElements()) {
                    URL url = resources.nextElement();
                    String className = null;
                    try {
                        BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream(), charset));
                        Throwable throwable = null;
                        try {
                            while ((className = reader.readLine()) != null) {
                                if (!StringUtils.isNotEmpty(className)) continue;
                                ret.add(classLoader.loadClass(className));
                            }
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (reader == null) continue;
                            if (throwable != null) {
                                try {
                                    reader.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            reader.close();
                        }
                    }
                    catch (ClassNotFoundException e) {
                        throw new ConfigurationException("Class file: '" + className + "' not in " + url);
                    }
                }
                return ret;
            }
            catch (IOException e) {
                throw new ContextException("Exception occurred when load from '" + resource + '\'', e);
            }
        }
        throw new ConfigurationException("Resource must start with 'META-INF'");
    }

    public static <T> Set<T> loadBeansFromMetaInfo(String resource) {
        return ContextUtils.loadBeansFromMetaInfo(resource, ContextUtils.getLastStartupContext());
    }

    public static <T> Set<T> loadBeansFromMetaInfo(String resource, BeanFactory beanFactory) {
        Set<Class<?>> classes = ContextUtils.loadFromMetaInfo(resource);
        HashSet ret = new HashSet();
        for (Class<?> aClass : classes) {
            Object obj = ClassUtils.newInstance(aClass, beanFactory);
            ret.add(obj);
        }
        return ret;
    }

    public static ExecutableParameterResolver[] getParameterResolvers() {
        return parameterResolvers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setParameterResolvers(ExecutableParameterResolver ... resolvers) {
        Assert.notNull((Object)resolvers, "ExecutableParameterResolvers must not null");
        Class<ContextUtils> clazz = ContextUtils.class;
        synchronized (ContextUtils.class) {
            parameterResolvers = OrderUtils.reversedSort(resolvers);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static void addParameterResolvers(ExecutableParameterResolver ... resolvers) {
        if (ObjectUtils.isNotEmpty(resolvers)) {
            ArrayList newResolvers = new ArrayList();
            if (ContextUtils.getParameterResolvers() != null) {
                Collections.addAll(newResolvers, ContextUtils.getParameterResolvers());
            }
            Collections.addAll(newResolvers, resolvers);
            ContextUtils.setParameterResolvers(newResolvers.toArray(new ExecutableParameterResolver[newResolvers.size()]));
        }
    }

    public static Object[] resolveParameter(Executable executable, BeanFactory beanFactory) {
        return ContextUtils.resolveParameter(executable, beanFactory, null);
    }

    public static Object[] resolveParameter(Executable executable, BeanFactory beanFactory, Object[] providedArgs) {
        Assert.notNull((Object)executable, "Executable must not be null");
        int parameterLength = executable.getParameterCount();
        if (parameterLength == 0) {
            return null;
        }
        Assert.notNull((Object)beanFactory, "BeanFactory must not be null");
        Object[] args = new Object[parameterLength];
        int i = 0;
        for (Parameter parameter : executable.getParameters()) {
            Object argument = ContextUtils.findProvidedArgument(parameter, providedArgs);
            if (argument == null) {
                argument = ContextUtils.getParameterResolver(parameter).resolve(parameter, beanFactory);
            }
            args[i++] = argument;
        }
        return args;
    }

    protected static Object findProvidedArgument(Parameter parameter, Object[] providedArgs) {
        if (ObjectUtils.isNotEmpty(providedArgs)) {
            Class<?> parameterType = parameter.getType();
            for (Object providedArg : providedArgs) {
                if (!parameterType.isInstance(providedArg)) continue;
                return providedArg;
            }
        }
        return null;
    }

    public static ExecutableParameterResolver getParameterResolver(Parameter parameter) {
        for (ExecutableParameterResolver resolver : ContextUtils.getParameterResolvers()) {
            if (!resolver.supports(parameter)) continue;
            return resolver;
        }
        throw new ConfigurationException("Target parameter:[" + parameter + "] not supports in this context.");
    }

    static {
        expressionEvaluator = new ExpressionEvaluator();
        ContextUtils.setParameterResolvers(new MapParameterResolver(), new ArrayParameterResolver(), new CollectionParameterResolver(), new ObjectSupplierParameterResolver(), new EnvExecutableParameterResolver(), new ValueExecutableParameterResolver(), new AutowiredParameterResolver());
    }

    private static final class ValueExecutableParameterResolver
    implements ExecutableParameterResolver {
        private ValueExecutableParameterResolver() {
        }

        @Override
        public boolean supports(Parameter parameter) {
            return parameter.isAnnotationPresent(Value.class);
        }

        @Override
        public Object resolve(Parameter parameter, BeanFactory beanFactory) {
            return expressionEvaluator.evaluate(parameter.getAnnotation(Value.class), parameter.getType());
        }
    }

    private static final class EnvExecutableParameterResolver
    implements ExecutableParameterResolver {
        private EnvExecutableParameterResolver() {
        }

        @Override
        public boolean supports(Parameter parameter) {
            return parameter.isAnnotationPresent(Env.class);
        }

        @Override
        public Object resolve(Parameter parameter, BeanFactory beanFactory) {
            return expressionEvaluator.evaluate(parameter.getAnnotation(Env.class), parameter.getType());
        }
    }
}

