/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.utils;

import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public final class ConcurrentCache<K, V> {
    private final int size;
    private final ConcurrentHashMap<K, V> eden;
    private final WeakHashMap<K, V> longterm;

    public ConcurrentCache(int size) {
        this.size = size;
        this.longterm = new WeakHashMap(size);
        this.eden = new ConcurrentHashMap(size);
    }

    public static <K, V> ConcurrentCache<K, V> create() {
        return ConcurrentCache.create(512);
    }

    public static <K, V> ConcurrentCache<K, V> create(int size) {
        return new ConcurrentCache<K, V>(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K k) {
        V v = this.eden.get(k);
        if (v == null) {
            WeakHashMap<K, V> weakHashMap = this.longterm;
            synchronized (weakHashMap) {
                v = this.longterm.get(k);
            }
            if (v != null) {
                this.eden.put(k, v);
            }
        }
        return v;
    }

    public V get(K k, Function<? super K, ? extends V> function) {
        V newValue;
        V v = this.get(k);
        if (v == null && (newValue = function.apply(k)) != null) {
            this.put(k, newValue);
            return newValue;
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(K k) {
        this.eden.remove(k);
        WeakHashMap<K, V> weakHashMap = this.longterm;
        synchronized (weakHashMap) {
            this.longterm.remove(k);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.eden.clear();
        WeakHashMap<K, V> weakHashMap = this.longterm;
        synchronized (weakHashMap) {
            this.longterm.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(K k, V v) {
        ConcurrentHashMap<K, V> eden = this.eden;
        if (eden.size() >= this.size) {
            WeakHashMap<K, V> weakHashMap = this.longterm;
            synchronized (weakHashMap) {
                this.longterm.putAll(eden);
            }
            eden.clear();
        }
        eden.put(k, v);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAll(Map<? extends K, ? extends V> m) {
        ConcurrentHashMap<? extends K, ? extends V> eden = this.eden;
        if (eden.size() >= this.size) {
            WeakHashMap<K, V> weakHashMap = this.longterm;
            synchronized (weakHashMap) {
                this.longterm.putAll(eden);
            }
            eden.clear();
        }
        eden.putAll(m);
    }
}

