/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.utils;

import cn.taketoday.context.AnnotationAttributes;
import cn.taketoday.context.Constant;
import cn.taketoday.context.EmptyObject;
import cn.taketoday.context.Ordered;
import cn.taketoday.context.annotation.Autowired;
import cn.taketoday.context.asm.ClassReader;
import cn.taketoday.context.asm.ClassVisitor;
import cn.taketoday.context.asm.Label;
import cn.taketoday.context.asm.MethodVisitor;
import cn.taketoday.context.exception.BeanInstantiationException;
import cn.taketoday.context.exception.ContextException;
import cn.taketoday.context.factory.BeanDefinition;
import cn.taketoday.context.factory.BeanFactory;
import cn.taketoday.context.factory.BeanMetadata;
import cn.taketoday.context.factory.BeanProperty;
import cn.taketoday.context.io.Resource;
import cn.taketoday.context.loader.CandidateComponentScanner;
import cn.taketoday.context.utils.Assert;
import cn.taketoday.context.utils.CollectionUtils;
import cn.taketoday.context.utils.ConcurrentCache;
import cn.taketoday.context.utils.ContextUtils;
import cn.taketoday.context.utils.ExceptionUtils;
import cn.taketoday.context.utils.GenericTypeResolver;
import cn.taketoday.context.utils.ObjectUtils;
import cn.taketoday.context.utils.ReflectionUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.Inherited;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.time.temporal.Temporal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.WeakHashMap;
import java.util.function.Function;

public abstract class ClassUtils {
    private static ClassLoader classLoader;
    static final HashMap<String, Class<?>> PRIMITIVE_CACHE;
    static final HashSet<Class<? extends Annotation>> IGNORE_ANNOTATION_CLASS;
    static final ParameterFunction PARAMETER_NAMES_FUNCTION;
    static final WeakHashMap<AnnotationKey<?>, Object> ANNOTATIONS;
    static final ConcurrentCache<Class<?>, Map<Method, String[]>> PARAMETER_NAMES_CACHE;
    static final WeakHashMap<AnnotationKey<?>, AnnotationAttributes[]> ANNOTATION_ATTRIBUTES;
    public static HashSet<Class<?>> primitiveTypes;
    private static boolean enableParamNameTypeChecking;

    public static void addIgnoreAnnotationClass(Class<? extends Annotation> annotationClass) {
        IGNORE_ANNOTATION_CLASS.add(annotationClass);
    }

    public static void clearCache() {
        ANNOTATIONS.clear();
        ANNOTATION_ATTRIBUTES.clear();
        PARAMETER_NAMES_CACHE.clear();
    }

    public static void setClassLoader(ClassLoader classLoader) {
        ClassUtils.classLoader = classLoader;
    }

    public static ClassLoader getClassLoader() {
        return classLoader;
    }

    public static boolean isPresent(String className) {
        Assert.notNull((Object)className, "class name can't be null");
        try {
            ClassUtils.forName(className);
            return true;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    public static Class<?> resolvePrimitiveClassName(String name) {
        if (name != null && name.length() <= 8) {
            return PRIMITIVE_CACHE.get(name);
        }
        return null;
    }

    public static Class<?> forName(String name, ClassLoader classLoader) throws ClassNotFoundException {
        Class<?> clazz = ClassUtils.resolvePrimitiveClassName(name);
        if (clazz != null) {
            return clazz;
        }
        if (name.endsWith("[]")) {
            Class<?> elementClass = ClassUtils.forName(name.substring(0, name.length() - "[]".length()));
            return Array.newInstance(elementClass, 0).getClass();
        }
        if (name.startsWith("[L") && name.endsWith(";")) {
            Class<?> elementClass = ClassUtils.forName(name.substring("[L".length(), name.length() - 1));
            return Array.newInstance(elementClass, 0).getClass();
        }
        if (name.startsWith("[")) {
            Class<?> elementClass = ClassUtils.forName(name.substring("[".length()));
            return Array.newInstance(elementClass, 0).getClass();
        }
        if (classLoader == null) {
            classLoader = ClassUtils.getClassLoader();
        }
        try {
            return Class.forName(name, false, classLoader);
        }
        catch (ClassNotFoundException ex) {
            int lastDotIndex = name.lastIndexOf(46);
            if (lastDotIndex != -1) {
                String innerClassName = name.substring(0, lastDotIndex) + '$' + name.substring(lastDotIndex + 1);
                try {
                    return Class.forName(innerClassName, false, classLoader);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            throw ex;
        }
    }

    public static Class<?> forName(String name) throws ClassNotFoundException {
        return ClassUtils.forName(name, classLoader);
    }

    public static <T> Class<T> loadClass(String name) {
        return ClassUtils.loadClass(name, classLoader);
    }

    public static <T> Class<T> loadClass(String name, ClassLoader classLoader) {
        Assert.notNull((Object)classLoader, "ClassLoader can't be null");
        try {
            return classLoader.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static Set<Class<?>> scan(String ... locations) {
        return new CandidateComponentScanner().scan(locations);
    }

    public static void scan(Set<Class<?>> scanClasses) {
        new CandidateComponentScanner().setCandidates(scanClasses).scan();
    }

    public static String getClassName(ClassReader r) {
        return r.getClassName().replace('/', '.');
    }

    public static String getClassName(byte[] classFile) {
        return ClassUtils.getClassName(new ClassReader(classFile));
    }

    public static String getClassName(Resource resource) throws IOException {
        try (InputStream inputStream = resource.getInputStream();){
            String string = ClassUtils.getClassName(inputStream);
            return string;
        }
    }

    public static String getClassName(InputStream inputStream) throws IOException {
        return ClassUtils.getClassName(new ClassReader(inputStream));
    }

    public static <T extends Annotation> T[] getAnnotationArray(AnnotatedElement element, Class<T> annotationClass, Class<? extends T> implClass) {
        if (annotationClass == null) {
            return null;
        }
        AnnotationKey<T> key = new AnnotationKey<T>(element, annotationClass);
        Object ret = ANNOTATIONS.get(key);
        if (ret == null) {
            Object[] annAttributes = ClassUtils.getAnnotationAttributesArray(key);
            if (ObjectUtils.isEmpty(annAttributes)) {
                ret = EmptyObject.INSTANCE;
            } else {
                int i = 0;
                Assert.notNull(implClass, "Implementation class can't be null");
                ret = Array.newInstance(annotationClass, annAttributes.length);
                for (Object attributes : annAttributes) {
                    Array.set(ret, i++, ClassUtils.injectAttributes((AnnotationAttributes)attributes, annotationClass, ClassUtils.newInstance(implClass)));
                }
            }
            ANNOTATIONS.put(key, ret);
        }
        return ret == EmptyObject.INSTANCE ? null : (Annotation[])ret;
    }

    public static <T extends Annotation> T[] getAnnotationArray(AnnotatedElement element, Class<T> targetClass) {
        if (targetClass == null) {
            return null;
        }
        AnnotationKey<T> key = new AnnotationKey<T>(element, targetClass);
        Object ret = ANNOTATIONS.get(key);
        if (ret == null) {
            Object[] annAttributes = ClassUtils.getAnnotationAttributesArray(key);
            if (ObjectUtils.isEmpty(annAttributes)) {
                ret = EmptyObject.INSTANCE;
            } else {
                int i = 0;
                ret = Array.newInstance(targetClass, annAttributes.length);
                for (Object attributes : annAttributes) {
                    Array.set(ret, i++, ClassUtils.getAnnotationProxy(targetClass, (AnnotationAttributes)attributes));
                }
            }
            ANNOTATIONS.put(key, ret);
        }
        return ret == EmptyObject.INSTANCE ? null : (Annotation[])ret;
    }

    public static <A extends Annotation> List<A> getAnnotation(AnnotatedElement element, Class<A> annotationClass, Class<? extends A> implClass) {
        return Arrays.asList(ClassUtils.getAnnotationArray((AnnotatedElement)element, annotationClass, implClass));
    }

    public static <A> A injectAttributes(AnnotationAttributes source, Class<?> annotationClass, A instance) {
        Class<?> implClass = instance.getClass();
        BeanMetadata metadata = BeanMetadata.ofClass(implClass);
        for (Method method : annotationClass.getDeclaredMethods()) {
            String name = method.getName();
            BeanProperty beanProperty = metadata.getBeanProperty(name);
            if (beanProperty == null) {
                throw new ContextException("You must specify a field: [" + name + "] in class: [" + implClass.getName() + "]");
            }
            beanProperty.setValue(instance, source.get(name));
        }
        return instance;
    }

    public static AnnotationAttributes getAnnotationAttributes(Annotation annotation) {
        return ClassUtils.getAnnotationAttributes(annotation.annotationType(), annotation);
    }

    public static AnnotationAttributes getAnnotationAttributes(Class<? extends Annotation> annotationType, Object annotation) {
        try {
            Method[] declaredMethods = ReflectionUtils.getDeclaredMethods(annotationType);
            AnnotationAttributes attributes = new AnnotationAttributes(annotationType, declaredMethods.length);
            for (Method method : declaredMethods) {
                attributes.put(method.getName(), method.invoke(annotation, new Object[0]));
            }
            return attributes;
        }
        catch (Throwable ex) {
            ex = ExceptionUtils.unwrapThrowable(ex);
            throw new ContextException("An Exception Occurred When Getting Annotation Attributes", ex);
        }
    }

    public static <T extends Annotation> List<T> getAnnotation(AnnotatedElement annotatedElement, Class<T> annotationClass) {
        return Arrays.asList(ClassUtils.getAnnotationArray((AnnotatedElement)annotatedElement, annotationClass));
    }

    public static <T extends Annotation> T getAnnotation(Class<T> annotationClass, Class<? extends T> implClass, AnnotatedElement element) {
        Object[] array = ClassUtils.getAnnotationArray((AnnotatedElement)element, annotationClass, implClass);
        return (T)(ObjectUtils.isEmpty(array) ? null : array[0]);
    }

    public static <T extends Annotation> T getAnnotation(Object annotated, Class<T> annotationClass) {
        return annotated == null ? null : (T)ClassUtils.getAnnotation(annotationClass, annotated.getClass());
    }

    public static <T extends Annotation> T getAnnotation(Class<T> annotationClass, AnnotatedElement annotatedElement) {
        Object[] annotationArray = ClassUtils.getAnnotationArray((AnnotatedElement)annotatedElement, annotationClass);
        return (T)(ObjectUtils.isEmpty(annotationArray) ? null : annotationArray[0]);
    }

    public static <T extends Annotation> T getAnnotationProxy(Class<T> annotationClass, AnnotationAttributes attributes) {
        return (T)((Annotation)annotationClass.cast(Proxy.newProxyInstance(classLoader, new Class[]{annotationClass, Annotation.class}, (proxy, method, args) -> {
            switch (method.getName()) {
                case "equals": {
                    return ClassUtils.eq(proxy, attributes, args[0]);
                }
                case "hashCode": {
                    return attributes.hashCode();
                }
                case "toString": {
                    return attributes.toString();
                }
                case "annotationType": {
                    return annotationClass;
                }
            }
            return attributes.get(method.getName());
        })));
    }

    private static Object eq(Object proxy, AnnotationAttributes attributes, Object object) throws IllegalAccessException, InvocationTargetException {
        if (proxy == object) {
            return true;
        }
        Class<?> targetClass = proxy.getClass();
        if (targetClass.isInstance(object)) {
            for (Map.Entry entry : attributes.entrySet()) {
                String key = (String)entry.getKey();
                Method method = ReflectionUtils.findMethod(targetClass, key);
                if (method == null) {
                    return false;
                }
                if (method.getReturnType() != Void.TYPE && Objects.deepEquals(method.invoke(object, new Object[0]), entry.getValue())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static <T extends Annotation> List<AnnotationAttributes> getAnnotationAttributes(AnnotatedElement element, Class<T> annotationClass) {
        return Arrays.asList(ClassUtils.getAnnotationAttributesArray(element, annotationClass));
    }

    public static <T extends Annotation> AnnotationAttributes getAnnotationAttributes(Class<T> annotationClass, AnnotatedElement element) {
        Object[] array = ClassUtils.getAnnotationAttributesArray(element, annotationClass);
        return ObjectUtils.isEmpty(array) ? null : array[0];
    }

    public static <T extends Annotation> AnnotationAttributes[] getAnnotationAttributesArray(AnnotatedElement element, Class<T> targetClass) {
        if (targetClass == null) {
            return Constant.EMPTY_ANNOTATION_ATTRIBUTES;
        }
        return ClassUtils.getAnnotationAttributesArray(new AnnotationKey<T>(element, targetClass));
    }

    public static <T extends Annotation> AnnotationAttributes[] getAnnotationAttributesArray(AnnotationKey<T> key) {
        AnnotationAttributes[] ret = ANNOTATION_ATTRIBUTES.get(key);
        if (ret == null) {
            Object[] annotations = ((AnnotationKey)key).element.getAnnotations();
            if (ObjectUtils.isEmpty(annotations)) {
                ret = Constant.EMPTY_ANNOTATION_ATTRIBUTES;
            } else {
                Class annotationClass = ((AnnotationKey)key).annotationClass;
                LinkedList<AnnotationAttributes> result = new LinkedList<AnnotationAttributes>();
                for (Object annotation : annotations) {
                    List<AnnotationAttributes> attr = ClassUtils.getAnnotationAttributes((Annotation)annotation, annotationClass);
                    if (attr.isEmpty()) continue;
                    result.addAll(attr);
                }
                ret = result.isEmpty() ? Constant.EMPTY_ANNOTATION_ATTRIBUTES : result.toArray(new AnnotationAttributes[result.size()]);
            }
            ANNOTATION_ATTRIBUTES.putIfAbsent(key, ret);
        }
        return ret;
    }

    public static <T extends Annotation> List<AnnotationAttributes> getAnnotationAttributes(Annotation annotation, Class<T> target) {
        if (annotation == null) {
            return Collections.emptyList();
        }
        Class<? extends Annotation> annotationType = annotation.annotationType();
        if (annotationType == target) {
            return Collections.singletonList(ClassUtils.getAnnotationAttributes(annotationType, annotation));
        }
        if (IGNORE_ANNOTATION_CLASS.contains(annotationType)) {
            return Collections.emptyList();
        }
        LinkedList<AnnotationAttributes> ret = new LinkedList<AnnotationAttributes>();
        ClassUtils.findTargetAttributes(annotationType, target, ret, new TransformTarget(annotation, annotationType), IGNORE_ANNOTATION_CLASS);
        return ret;
    }

    static <T extends Annotation> void findTargetAttributes(Class<?> source, Class<T> targetType, List<AnnotationAttributes> attributes, AnnotationAttributesTransformer transformer, Set<Class<? extends Annotation>> ignoreAnnotation) {
        for (Annotation current : source.getAnnotations()) {
            Class<? extends Annotation> candidateType = current.annotationType();
            if (candidateType == source || ignoreAnnotation.contains(candidateType)) continue;
            if (candidateType == targetType) {
                attributes.add(ClassUtils.getAnnotationAttributes(current, candidateType, transformer));
                continue;
            }
            ClassUtils.findTargetAttributes(candidateType, targetType, attributes, transformer, ignoreAnnotation);
        }
    }

    public static AnnotationAttributes getAnnotationAttributes(Annotation current, Class<? extends Annotation> candidateType, AnnotationAttributesTransformer transformer) {
        Method[] declaredMethods = ReflectionUtils.getDeclaredMethods(candidateType);
        AnnotationAttributes target = new AnnotationAttributes(candidateType, declaredMethods.length);
        for (Method method : declaredMethods) {
            Object value = transformer.get(method);
            if (value == null) {
                value = ReflectionUtils.invokeMethod(method, current);
            }
            target.put(method.getName(), value);
        }
        return target;
    }

    public static <A extends Annotation> boolean isAnnotationPresent(AnnotatedElement element, Class<A> annType) {
        return annType != null && element != null && (element.isAnnotationPresent(annType) || ObjectUtils.isNotEmpty(ClassUtils.getAnnotationAttributesArray(element, annType)));
    }

    public static <T> T newInstance(Class<T> beanClass) {
        return ClassUtils.newInstance(beanClass, (BeanFactory)ContextUtils.getLastStartupContext());
    }

    public static <T> T newInstance(String beanClassName) throws ClassNotFoundException {
        return (T)ClassUtils.newInstance(classLoader.loadClass(beanClassName));
    }

    public static Object newInstance(BeanDefinition def, BeanFactory beanFactory) {
        return def.newInstance(beanFactory);
    }

    public static <T> T newInstance(Class<T> beanClass, BeanFactory beanFactory) {
        return ClassUtils.newInstance(beanClass, beanFactory, null);
    }

    public static <T> T newInstance(Class<T> beanClass, BeanFactory beanFactory, Object[] providedArgs) {
        Constructor<T> constructor = ClassUtils.obtainConstructor(beanClass);
        Object[] parameter = ContextUtils.resolveParameter(constructor, beanFactory, providedArgs);
        return ClassUtils.newInstance(constructor, parameter);
    }

    public static <T> T newInstance(Constructor<T> constructor, Object[] parameter) {
        try {
            return constructor.newInstance(parameter);
        }
        catch (InstantiationException ex) {
            throw new BeanInstantiationException(constructor, "Is it an abstract class?", (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            throw new BeanInstantiationException(constructor, "Is the constructor accessible?", (Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            throw new BeanInstantiationException(constructor, "Illegal arguments for constructor", (Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            throw new BeanInstantiationException(constructor, "Constructor threw exception", ex.getTargetException());
        }
    }

    public static <T> Constructor<T> obtainConstructor(Class<T> beanClass) {
        Constructor<T> ret = ClassUtils.getSuitableConstructor(beanClass);
        if (ret == null) {
            throw new BeanInstantiationException(beanClass, "No suitable constructor found");
        }
        return ret;
    }

    public static <T> Constructor<T> getSuitableConstructor(Class<T> beanClass) {
        try {
            return ReflectionUtils.accessibleConstructor(beanClass, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            Constructor<?>[] constructors = beanClass.getDeclaredConstructors();
            if (constructors.length == 1) {
                return ReflectionUtils.makeAccessible(constructors[0]);
            }
            for (Constructor<?> constructor : constructors) {
                if (!constructor.isAnnotationPresent(Autowired.class)) continue;
                return ReflectionUtils.makeAccessible(constructor);
            }
            return null;
        }
    }

    public static <T> Class<T> getUserClass(T synthetic) {
        return ClassUtils.getUserClass(Objects.requireNonNull(synthetic).getClass());
    }

    public static <T> Class<T> getUserClass(Class<T> syntheticClass) {
        Class<T> superclass;
        if (Objects.requireNonNull(syntheticClass).getName().lastIndexOf("$$") > -1 && (superclass = syntheticClass.getSuperclass()) != null && superclass != Object.class) {
            return superclass;
        }
        return syntheticClass;
    }

    public static <T> Class<T> getUserClass(String name) {
        int i = Objects.requireNonNull(name).indexOf("$$");
        return i > 0 ? ClassUtils.loadClass(name.substring(0, i)) : ClassUtils.loadClass(name);
    }

    public static Type[] getGenerics(Class<?> type) {
        if (type != null) {
            Class<?> superclass;
            Type genericSuperclass = type.getGenericSuperclass();
            if (genericSuperclass == (superclass = type.getSuperclass()) && genericSuperclass != Object.class) {
                return ClassUtils.getGenerics(superclass);
            }
            if (genericSuperclass instanceof ParameterizedType) {
                return ClassUtils.getActualTypeArguments(genericSuperclass);
            }
            Object[] genericInterfaces = type.getGenericInterfaces();
            if (ObjectUtils.isNotEmpty(genericInterfaces)) {
                return ClassUtils.getActualTypeArguments((Type)genericInterfaces[0]);
            }
        }
        return null;
    }

    public static Type[] getGenericTypes(Field property) {
        return property != null ? ClassUtils.getActualTypeArguments(property.getGenericType()) : null;
    }

    public static Type[] getGenericTypes(Parameter parameter) {
        return parameter != null ? ClassUtils.getActualTypeArguments(parameter.getParameterizedType()) : null;
    }

    static Type[] getActualTypeArguments(Type pType) {
        if (pType instanceof ParameterizedType) {
            return ((ParameterizedType)pType).getActualTypeArguments();
        }
        return null;
    }

    public static Class<?>[] getGenerics(Class<?> type, Class<?> superClass) {
        return GenericTypeResolver.resolveTypeArguments(type, superClass);
    }

    public static String[] getMethodArgsNames(Method method) {
        return PARAMETER_NAMES_CACHE.get(method.getDeclaringClass(), PARAMETER_NAMES_FUNCTION).get(method);
    }

    public static void setEnableParamNameTypeChecking(boolean enableParamNameTypeChecking) {
        ClassUtils.enableParamNameTypeChecking = enableParamNameTypeChecking;
    }

    public static String getQualifiedMethodName(Method method) {
        return ClassUtils.getQualifiedMethodName(method, null);
    }

    public static String getQualifiedMethodName(Method method, Class<?> clazz) {
        Assert.notNull((Object)method, "Method must not be null");
        return (clazz != null ? clazz : method.getDeclaringClass()).getName() + '.' + method.getName();
    }

    public static boolean isSimpleType(Class<?> clazz) {
        return primitiveTypes.contains(clazz) || clazz.isArray() && ClassUtils.isSimpleType(clazz.getComponentType());
    }

    public static Class<?>[] getAllInterfaces(Object instance) {
        Assert.notNull(instance, "Instance must not be null");
        return ClassUtils.getAllInterfacesForClass(instance.getClass());
    }

    public static Class<?>[] getAllInterfacesForClass(Class<?> clazz) {
        return ClassUtils.getAllInterfacesForClass(clazz, null);
    }

    public static Class<?>[] getAllInterfacesForClass(Class<?> clazz, ClassLoader classLoader) {
        return ClassUtils.toClassArray(ClassUtils.getAllInterfacesForClassAsSet(clazz, classLoader));
    }

    public static Class<?>[] toClassArray(Collection<Class<?>> collection) {
        return CollectionUtils.isEmpty(collection) ? Constant.EMPTY_CLASS_ARRAY : collection.toArray(Constant.EMPTY_CLASS_ARRAY);
    }

    public static Set<Class<?>> getAllInterfacesAsSet(Object instance) {
        Assert.notNull(instance, "Instance must not be null");
        return ClassUtils.getAllInterfacesForClassAsSet(instance.getClass());
    }

    public static Set<Class<?>> getAllInterfacesForClassAsSet(Class<?> clazz) {
        return ClassUtils.getAllInterfacesForClassAsSet(clazz, null);
    }

    public static Set<Class<?>> getAllInterfacesForClassAsSet(Class<?> clazz, ClassLoader classLoader) {
        Assert.notNull(clazz, "Class must not be null");
        if (clazz.isInterface() && ClassUtils.isVisible(clazz, classLoader)) {
            return Collections.singleton(clazz);
        }
        LinkedHashSet interfaces = new LinkedHashSet();
        for (Class<?> current = clazz; current != null; current = current.getSuperclass()) {
            Class<?>[] ifcs;
            for (Class<?> ifc : ifcs = current.getInterfaces()) {
                if (!ClassUtils.isVisible(ifc, classLoader)) continue;
                interfaces.add(ifc);
            }
        }
        return interfaces;
    }

    public static boolean isVisible(Class<?> clazz, ClassLoader classLoader) {
        if (classLoader == null) {
            return true;
        }
        try {
            if (clazz.getClassLoader() == classLoader) {
                return true;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return ClassUtils.isLoadable(clazz, classLoader);
    }

    private static boolean isLoadable(Class<?> clazz, ClassLoader classLoader) {
        try {
            return clazz == classLoader.loadClass(clazz.getName());
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    public static String classNamesToString(Class<?> ... classes) {
        return ClassUtils.classNamesToString(Arrays.asList(classes));
    }

    public static String classNamesToString(Collection<Class<?>> classes) {
        if (CollectionUtils.isEmpty(classes)) {
            return "[]";
        }
        StringJoiner stringJoiner = new StringJoiner(", ", "[", "]");
        for (Class<?> clazz : classes) {
            stringJoiner.add(clazz.getName());
        }
        return stringJoiner.toString();
    }

    public static boolean hasMethod(Class<?> clazz, Method method) {
        Class<?>[] paramTypes;
        Assert.notNull(clazz, "Class must not be null");
        Assert.notNull((Object)method, "Method must not be null");
        if (clazz == method.getDeclaringClass()) {
            return true;
        }
        String methodName = method.getName();
        return ClassUtils.getMethodOrNull(clazz, methodName, paramTypes = method.getParameterTypes()) != null;
    }

    private static Method getMethodOrNull(Class<?> clazz, String methodName, Class<?>[] paramTypes) {
        try {
            return clazz.getMethod(methodName, paramTypes);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    public static boolean isCandidateClass(Class<?> clazz, Collection<Class<? extends Annotation>> annotationTypes) {
        for (Class<? extends Annotation> annotationType : annotationTypes) {
            if (!ClassUtils.isCandidateClass(clazz, annotationType)) continue;
            return true;
        }
        return false;
    }

    public static boolean isCandidateClass(Class<?> clazz, Class<? extends Annotation> annotationType) {
        return ClassUtils.isCandidateClass(clazz, annotationType.getName());
    }

    public static boolean isCandidateClass(Class<?> clazz, String annotationName) {
        if (annotationName.startsWith("java.")) {
            return true;
        }
        return !ClassUtils.hasPlainJavaAnnotationsOnly(clazz);
    }

    static boolean hasPlainJavaAnnotationsOnly(Class<?> type) {
        return type.getName().startsWith("java.") || type == Ordered.class;
    }

    public static Method getMostSpecificMethod(Method method, Class<?> targetClass) {
        if (targetClass != null && targetClass != method.getDeclaringClass() && ClassUtils.isOverridable(method, targetClass)) {
            try {
                if (Modifier.isPublic(method.getModifiers())) {
                    try {
                        return targetClass.getMethod(method.getName(), method.getParameterTypes());
                    }
                    catch (NoSuchMethodException ex) {
                        return method;
                    }
                }
                Method specificMethod = ReflectionUtils.findMethod(targetClass, method.getName(), method.getParameterTypes());
                return specificMethod != null ? specificMethod : method;
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return method;
    }

    private static boolean isOverridable(Method method, Class<?> targetClass) {
        if (Modifier.isPrivate(method.getModifiers())) {
            return false;
        }
        if (Modifier.isPublic(method.getModifiers()) || Modifier.isProtected(method.getModifiers())) {
            return true;
        }
        return targetClass == null || ClassUtils.getPackageName(method.getDeclaringClass()).equals(ClassUtils.getPackageName(targetClass));
    }

    public static String getPackageName(Class<?> clazz) {
        Assert.notNull(clazz, "Class must not be null");
        return ClassUtils.getPackageName(clazz.getName());
    }

    public static String getPackageName(String fqClassName) {
        Assert.notNull((Object)fqClassName, "Class name must not be null");
        int lastDotIndex = fqClassName.lastIndexOf(46);
        return lastDotIndex != -1 ? fqClassName.substring(0, lastDotIndex) : "";
    }

    public static Object[] adaptArgumentsIfNecessary(Method method, Object[] arguments) {
        Object varargArray;
        int varargIndex;
        Class<?>[] paramTypes;
        Class<?> varargType;
        if (ObjectUtils.isEmpty(arguments)) {
            return Constant.EMPTY_OBJECT_ARRAY;
        }
        if (method.isVarArgs() && method.getParameterCount() == arguments.length && (varargType = (paramTypes = method.getParameterTypes())[varargIndex = paramTypes.length - 1]).isArray() && (varargArray = arguments[varargIndex]) instanceof Object[] && !varargType.isInstance(varargArray)) {
            Object[] newArguments = new Object[arguments.length];
            System.arraycopy(arguments, 0, newArguments, 0, varargIndex);
            Class<?> targetElementType = varargType.getComponentType();
            int varargLength = Array.getLength(varargArray);
            Object newVarargArray = Array.newInstance(targetElementType, varargLength);
            System.arraycopy(varargArray, 0, newVarargArray, 0, varargLength);
            newArguments[varargIndex] = newVarargArray;
            return newArguments;
        }
        return arguments;
    }

    public static String getQualifiedName(Class<?> clazz) {
        Assert.notNull(clazz, "Class must not be null");
        return clazz.getTypeName();
    }

    public static String getShortName(String className) {
        Assert.hasLength(className, "Class name must not be empty");
        int lastDotIndex = className.lastIndexOf(46);
        int nameEndIndex = className.indexOf("$$");
        if (nameEndIndex == -1) {
            nameEndIndex = className.length();
        }
        String shortName = className.substring(lastDotIndex + 1, nameEndIndex);
        shortName = shortName.replace('$', '.');
        return shortName;
    }

    public static String getShortName(Class<?> clazz) {
        return ClassUtils.getShortName(ClassUtils.getQualifiedName(clazz));
    }

    public static String classPackageAsResourcePath(Class<?> clazz) {
        if (clazz == null) {
            return "";
        }
        String className = clazz.getName();
        int packageEndIndex = className.lastIndexOf(46);
        if (packageEndIndex == -1) {
            return "";
        }
        String packageName = className.substring(0, packageEndIndex);
        return packageName.replace('.', '/');
    }

    public static Class<?> getEnumType(Class<?> targetType) {
        Class<?> enumType;
        for (enumType = targetType; enumType != null && !enumType.isEnum(); enumType = enumType.getSuperclass()) {
        }
        Assert.notNull(enumType, () -> "The target type " + targetType.getName() + " does not refer to an enum");
        return enumType;
    }

    public static int getParameterIndex(Parameter parameter) {
        int i;
        Executable executable = parameter.getDeclaringExecutable();
        Parameter[] allParams = executable.getParameters();
        for (i = 0; i < allParams.length; ++i) {
            if (parameter != allParams[i]) continue;
            return i;
        }
        for (i = 0; i < allParams.length; ++i) {
            if (!parameter.equals(allParams[i])) continue;
            return i;
        }
        throw new IllegalArgumentException("Given parameter [" + parameter + "] does not match any parameter in the declaring executable");
    }

    public static Parameter getParameter(Executable executable, int parameterIndex) {
        Assert.notNull((Object)executable, "Executable must not be null");
        Parameter[] parameters = executable.getParameters();
        if (parameterIndex < 0 || parameterIndex >= parameters.length) {
            throw new IllegalArgumentException("parameter index is illegal");
        }
        return parameters[parameterIndex];
    }

    static {
        PRIMITIVE_CACHE = new HashMap(32);
        IGNORE_ANNOTATION_CLASS = new HashSet();
        PARAMETER_NAMES_FUNCTION = new ParameterFunction();
        ANNOTATIONS = new WeakHashMap(128);
        PARAMETER_NAMES_CACHE = ConcurrentCache.create(64);
        ANNOTATION_ATTRIBUTES = new WeakHashMap(128);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = ClassUtils.class.getClassLoader();
        }
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        ClassUtils.setClassLoader(classLoader);
        HashSet<Class<Object>> primitiveTypes = new HashSet<Class<Object>>();
        Collections.addAll(primitiveTypes, Boolean.TYPE, Byte.TYPE, Character.TYPE, Integer.TYPE, Long.TYPE, Double.TYPE, Float.TYPE, Short.TYPE, boolean[].class, byte[].class, char[].class, double[].class, float[].class, int[].class, long[].class, short[].class);
        primitiveTypes.add(Void.TYPE);
        for (Class clazz : primitiveTypes) {
            PRIMITIVE_CACHE.put(clazz.getName(), clazz);
        }
        primitiveTypes.add(String.class);
        primitiveTypes.add(Byte.class);
        primitiveTypes.add(Short.class);
        primitiveTypes.add(Character.class);
        primitiveTypes.add(Integer.class);
        primitiveTypes.add(Long.class);
        primitiveTypes.add(Float.class);
        primitiveTypes.add(Double.class);
        primitiveTypes.add(Boolean.class);
        primitiveTypes.add(Date.class);
        primitiveTypes.add(Class.class);
        primitiveTypes.add(BigInteger.class);
        primitiveTypes.add(BigDecimal.class);
        primitiveTypes.add(URI.class);
        primitiveTypes.add(URL.class);
        primitiveTypes.add(Enum.class);
        primitiveTypes.add(Locale.class);
        primitiveTypes.add(Number.class);
        primitiveTypes.add(Temporal.class);
        primitiveTypes.add(CharSequence.class);
        ClassUtils.addIgnoreAnnotationClass(Target.class);
        ClassUtils.addIgnoreAnnotationClass(Inherited.class);
        ClassUtils.addIgnoreAnnotationClass(Retention.class);
        ClassUtils.addIgnoreAnnotationClass(Repeatable.class);
        ClassUtils.addIgnoreAnnotationClass(Documented.class);
        ClassUtils.primitiveTypes = new HashSet(primitiveTypes);
        enableParamNameTypeChecking = Boolean.parseBoolean(System.getProperty("ClassUtils.enableParamNameTypeChecking", "true"));
    }

    static class LocalVariable {
        String name;
        String descriptor;

        LocalVariable(String name, String descriptor) {
            this.name = name;
            this.descriptor = descriptor;
        }
    }

    static final class MethodNode
    extends MethodVisitor {
        private final String name;
        private final String desc;
        private final LinkedList<LocalVariable> localVariables = new LinkedList();

        MethodNode(String name, String desc) {
            this.name = name;
            this.desc = desc;
        }

        @Override
        public void visitLocalVariable(String name, String descriptor, String signature, Label start, Label end, int index) {
            this.localVariables.add(new LocalVariable(name, descriptor));
        }
    }

    static final class ClassNode
    extends ClassVisitor {
        private final LinkedList<MethodNode> methodNodes = new LinkedList();

        ClassNode() {
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            if (ClassNode.isSyntheticOrBridged(access) || "<init>".equals(name) || "<clinit>".equals(name)) {
                return null;
            }
            MethodNode methodNode = new MethodNode(name, descriptor);
            this.methodNodes.add(methodNode);
            return methodNode;
        }

        private static boolean isSyntheticOrBridged(int access) {
            return (access & 0x1000 | access & 0x40) > 0;
        }
    }

    static final class ParameterFunction
    implements Function<Class<?>, Map<Method, String[]>> {
        ParameterFunction() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Map<Method, String[]> apply(Class<?> declaringClass) {
            HashMap<Method, String[]> map = new HashMap<Method, String[]>();
            String classFile = declaringClass.getName().replace('.', '/').concat(".class");
            try (InputStream resourceAsStream = classLoader.getResourceAsStream(classFile);){
                ClassNode classVisitor = new ClassNode();
                new ClassReader(resourceAsStream).accept(classVisitor, 0);
                for (MethodNode methodNode : classVisitor.methodNodes) {
                    Object[] argTypes;
                    cn.taketoday.context.asm.Type[] argumentTypes = cn.taketoday.context.asm.Type.getArgumentTypes(methodNode.desc);
                    if (argumentTypes.length == 0) {
                        argTypes = Constant.EMPTY_CLASS_ARRAY;
                    } else {
                        argTypes = new Class[argumentTypes.length];
                        int idx = 0;
                        for (cn.taketoday.context.asm.Type type : argumentTypes) {
                            argTypes[idx++] = ClassUtils.forName(type.getClassName());
                        }
                    }
                    Method method = ReflectionUtils.findMethod(declaringClass, methodNode.name, argTypes);
                    if (method == null) {
                        throw new NoSuchMethodException("No such method named: '" + methodNode.name + "' argTypes: '" + Arrays.toString(argTypes) + "' in: " + declaringClass);
                    }
                    int parameterCount = method.getParameterCount();
                    if (parameterCount == 0) {
                        map.put(method, Constant.EMPTY_STRING_ARRAY);
                        continue;
                    }
                    String[] paramNames = new String[parameterCount];
                    if (Modifier.isAbstract(method.getModifiers()) || method.isBridge() || method.isSynthetic()) {
                        int idx = 0;
                        for (Parameter parameter : method.getParameters()) {
                            paramNames[idx++] = parameter.getName();
                        }
                        map.put(method, paramNames);
                        continue;
                    }
                    LinkedList localVariables = methodNode.localVariables;
                    if (localVariables.size() >= parameterCount) {
                        int idx;
                        int n;
                        int n2 = n = Modifier.isStatic(method.getModifiers()) ? 0 : 1;
                        if (enableParamNameTypeChecking) {
                            idx = n;
                            int start = 0;
                            while (start < parameterCount) {
                                void var15_25;
                                cn.taketoday.context.asm.Type argument = argumentTypes[start];
                                if (!argument.equals(cn.taketoday.context.asm.Type.getType(((LocalVariable)localVariables.get((int)idx++)).descriptor))) {
                                    idx = ++var15_25;
                                    start = 0;
                                    continue;
                                }
                                paramNames[start] = ((LocalVariable)localVariables.get((int)(start + var15_25))).name;
                                ++start;
                            }
                        } else {
                            for (idx = 0; idx < parameterCount; ++idx) {
                                paramNames[idx] = ((LocalVariable)localVariables.get((int)(idx + n))).name;
                            }
                        }
                    }
                    map.put(method, paramNames);
                }
            }
            catch (IOException | ClassNotFoundException | IndexOutOfBoundsException | NoSuchMethodException e) {
                throw new ContextException("When visit declaring class: [" + declaringClass.getName() + ']', e);
            }
            return map;
        }
    }

    static final class TransformTarget
    implements AnnotationAttributesTransformer {
        private Method[] declaredMethods;
        private final Annotation annotation;
        private final Class<?> annotationType;

        public TransformTarget(Annotation annotation, Class<?> annotationType) {
            this.annotation = annotation;
            this.annotationType = annotationType;
        }

        @Override
        public void transform(AnnotationAttributes target) {
            Annotation annotation = this.annotation;
            for (Method method : this.getDeclaredMethods()) {
                Object value = target.get(method.getName());
                if (value != null && !TransformTarget.eq(method.getReturnType(), value.getClass())) continue;
                target.put(method.getName(), ReflectionUtils.invokeMethod(method, annotation));
            }
        }

        protected final Method[] getDeclaredMethods() {
            Method[] ret = this.declaredMethods;
            if (ret == null) {
                ret = ReflectionUtils.getDeclaredMethods(this.annotationType);
                this.declaredMethods = ret;
            }
            return ret;
        }

        @Override
        public Object get(Method targetMethod) {
            String name = targetMethod.getName();
            Annotation annotation = this.annotation;
            for (Method method : this.getDeclaredMethods()) {
                if (!method.getName().equals(name) || !TransformTarget.eq(method.getReturnType(), targetMethod.getReturnType())) continue;
                return ReflectionUtils.invokeMethod(method, annotation);
            }
            return null;
        }

        private static boolean eq(Class<?> returnType, Class<?> clazz) {
            if (returnType == clazz) {
                return true;
            }
            if (returnType.isPrimitive()) {
                switch (returnType.getName()) {
                    case "int": {
                        return clazz == Integer.class;
                    }
                    case "long": {
                        return clazz == Long.class;
                    }
                    case "byte": {
                        return clazz == Byte.class;
                    }
                    case "char": {
                        return clazz == Character.class;
                    }
                    case "float": {
                        return clazz == Float.class;
                    }
                    case "double": {
                        return clazz == Double.class;
                    }
                    case "short": {
                        return clazz == Short.class;
                    }
                    case "boolean": {
                        return clazz == Boolean.class;
                    }
                }
                return false;
            }
            return false;
        }
    }

    static interface AnnotationAttributesTransformer {
        public Object get(Method var1);

        public void transform(AnnotationAttributes var1);
    }

    public static class AnnotationKey<T>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final int hash;
        private final Class<T> annotationClass;
        private final AnnotatedElement element;

        public AnnotationKey(AnnotatedElement element, Class<T> annotationClass) {
            Assert.notNull((Object)element, "AnnotatedElement can't be null");
            this.element = element;
            this.annotationClass = annotationClass;
            this.hash = Objects.hash(element, annotationClass);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof AnnotationKey) {
                AnnotationKey other = (AnnotationKey)obj;
                return Objects.equals(this.element, other.element) && Objects.equals(this.annotationClass, other.annotationClass);
            }
            return false;
        }
    }
}

