/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.reflect;

import cn.taketoday.context.reflect.MethodAccessor;
import cn.taketoday.context.reflect.PropertyAccessor;
import cn.taketoday.context.reflect.SetterSupport;
import cn.taketoday.context.utils.Assert;
import cn.taketoday.context.utils.ReflectionUtils;
import java.lang.reflect.Method;

public class MethodAccessorPropertyAccessor
extends SetterSupport
implements PropertyAccessor {
    private final MethodAccessor writeAccessor;
    private final MethodAccessor readAccessor;

    public MethodAccessorPropertyAccessor(boolean primitive, Method setMethod, Method getMethod) {
        super(primitive);
        Assert.notNull((Object)setMethod, "setMethod must not be null");
        Assert.notNull((Object)getMethod, "getMethod must not be null");
        this.writeAccessor = ReflectionUtils.newMethodAccessor(setMethod);
        this.readAccessor = ReflectionUtils.newMethodAccessor(getMethod);
    }

    public MethodAccessorPropertyAccessor(boolean primitive, MethodAccessor writeAccessor, MethodAccessor readAccessor) {
        super(primitive);
        Assert.notNull((Object)writeAccessor, "writeAccessor must not be null");
        Assert.notNull((Object)readAccessor, "readAccessor must not be null");
        this.readAccessor = readAccessor;
        this.writeAccessor = writeAccessor;
    }

    @Override
    public Object get(Object obj) {
        return this.readAccessor.invoke(obj, null);
    }

    @Override
    protected void setInternal(Object obj, Object value) {
        this.writeAccessor.invoke(obj, new Object[]{value});
    }

    @Override
    public Method getReadMethod() {
        return this.readAccessor.getMethod();
    }

    @Override
    public Method getWriteMethod() {
        return this.writeAccessor.getMethod();
    }
}

