/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.reflect;

import cn.taketoday.context.reflect.PropertyAccessor;
import cn.taketoday.context.reflect.SetterSupport;
import cn.taketoday.context.utils.ReflectionUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class FieldPropertyAccessor
extends SetterSupport
implements PropertyAccessor {
    private final Field field;
    private final Method readMethod;
    private final Method writeMethod;

    public FieldPropertyAccessor(Field field, Method readMethod, Method writeMethod) {
        super(field.getType().isPrimitive());
        this.field = ReflectionUtils.makeAccessible(field);
        this.readMethod = readMethod;
        this.writeMethod = writeMethod;
    }

    @Override
    public Object get(Object obj) {
        return ReflectionUtils.getField(this.field, obj);
    }

    @Override
    protected void setInternal(Object obj, Object value) {
        ReflectionUtils.setField(this.field, obj, value);
    }

    @Override
    public Method getReadMethod() {
        return this.readMethod;
    }

    @Override
    public Method getWriteMethod() {
        return this.writeMethod;
    }
}

