/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.logger;

import cn.taketoday.context.logger.Level;
import cn.taketoday.context.logger.Logger;

public abstract class AbstractLogger
implements Logger {
    protected static final String FQCN = AbstractLogger.class.getName();

    @Override
    public void trace(String msg) {
        this.logInternal(Level.TRACE, msg);
    }

    @Override
    public void trace(String format, Object arg) {
        this.logInternal(Level.TRACE, format, new Object[]{arg});
    }

    @Override
    public void trace(String format, Object arg1, Object arg2) {
        this.logInternal(Level.TRACE, format, new Object[]{arg1, arg2});
    }

    @Override
    public void trace(String format, Object ... arguments) {
        this.logInternal(Level.TRACE, format, arguments);
    }

    @Override
    public void trace(String msg, Throwable t) {
        this.logInternal(Level.TRACE, msg, t);
    }

    @Override
    public void debug(String msg) {
        this.logInternal(Level.DEBUG, msg);
    }

    @Override
    public void debug(String format, Object arg) {
        this.logInternal(Level.DEBUG, format, new Object[]{arg});
    }

    @Override
    public void debug(String format, Object arg1, Object arg2) {
        this.logInternal(Level.DEBUG, format, new Object[]{arg1, arg2});
    }

    @Override
    public void debug(String format, Object ... arguments) {
        this.logInternal(Level.DEBUG, format, arguments);
    }

    @Override
    public void debug(String msg, Throwable t) {
        this.logInternal(Level.DEBUG, msg);
    }

    @Override
    public void info(String msg) {
        this.logInternal(Level.INFO, msg);
    }

    @Override
    public void info(String format, Object arg) {
        this.logInternal(Level.INFO, format, new Object[]{arg});
    }

    @Override
    public void info(String format, Object arg1, Object arg2) {
        this.logInternal(Level.INFO, format, new Object[]{arg1, arg2});
    }

    @Override
    public void info(String format, Object ... arguments) {
        this.logInternal(Level.INFO, format, arguments);
    }

    @Override
    public void info(String msg, Throwable t) {
        this.logInternal(Level.INFO, msg, t);
    }

    @Override
    public void warn(String msg) {
        this.logInternal(Level.WARN, msg);
    }

    @Override
    public void warn(String format, Object arg) {
        this.logInternal(Level.WARN, format, new Object[]{arg});
    }

    @Override
    public void warn(String format, Object ... arguments) {
        this.logInternal(Level.WARN, format, arguments);
    }

    @Override
    public void warn(String format, Object arg1, Object arg2) {
        this.logInternal(Level.WARN, format, new Object[]{arg1, arg2});
    }

    @Override
    public void warn(String msg, Throwable t) {
        this.logInternal(Level.WARN, msg, t);
    }

    @Override
    public void error(String msg) {
        this.logInternal(Level.ERROR, msg);
    }

    @Override
    public void error(String format, Object arg) {
        this.logInternal(Level.ERROR, format, new Object[]{arg});
    }

    @Override
    public void error(String format, Object arg1, Object arg2) {
        this.logInternal(Level.ERROR, format, new Object[]{arg1, arg2});
    }

    @Override
    public void error(String format, Object ... arguments) {
        this.logInternal(Level.ERROR, format, arguments);
    }

    @Override
    public void error(String msg, Throwable t) {
        this.logInternal(Level.ERROR, msg, t);
    }

    public final boolean isLevelEnabled(Level level) {
        switch (level) {
            case WARN: {
                return this.isWarnEnabled();
            }
            case TRACE: {
                return this.isTraceEnabled();
            }
            case DEBUG: {
                return this.isDebugEnabled();
            }
            case ERROR: {
                return this.isErrorEnabled();
            }
        }
        return this.isInfoEnabled();
    }

    protected void logInternal(Level level, String msg) {
        this.logInternal(level, msg, (Object[])null);
    }

    protected void logInternal(Level level, String msg, Throwable t) {
        this.logInternal(level, msg, t, null);
    }

    protected void logInternal(Level level, String msg, Object[] args) {
        this.logInternal(level, msg, null, args);
    }

    protected abstract void logInternal(Level var1, String var2, Throwable var3, Object[] var4);
}

