/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.loader;

import cn.taketoday.context.OrderedSupport;
import cn.taketoday.context.exception.ContextException;
import cn.taketoday.context.factory.AbstractBeanFactory;
import cn.taketoday.context.factory.AbstractPropertySetter;
import cn.taketoday.context.factory.ObjectSupplier;
import cn.taketoday.context.factory.PropertySetter;
import cn.taketoday.context.loader.AutowiredPropertyResolver;
import cn.taketoday.context.loader.PropertyValueResolver;
import cn.taketoday.context.utils.ResolvableType;
import java.lang.reflect.Field;
import java.util.Objects;
import java.util.function.Supplier;

public class ObjectSupplierPropertyResolver
extends OrderedSupport
implements PropertyValueResolver {
    public ObjectSupplierPropertyResolver() {
        this(0x3FFFFFFF);
    }

    public ObjectSupplierPropertyResolver(int order) {
        super(order);
    }

    @Override
    public boolean supportsProperty(Field field) {
        return (field.getType() == Supplier.class || field.getType() == ObjectSupplier.class) && AutowiredPropertyResolver.isInjectable(field);
    }

    @Override
    public PropertySetter resolveProperty(Field field) throws ContextException {
        ResolvableType resolvableType = ResolvableType.forField(field);
        if (resolvableType.hasGenerics()) {
            ResolvableType generic = resolvableType.getGeneric(0);
            Class<?> aClass = generic.toClass();
            return new ObjectSupplierPropertySetter(field, aClass);
        }
        throw new UnsupportedOperationException("Unsupported '" + field + "' In -> " + field.getDeclaringClass());
    }

    static class ObjectSupplierPropertySetter
    extends AbstractPropertySetter
    implements PropertySetter {
        final Class<?> target;

        public ObjectSupplierPropertySetter(Field field, Class<?> target) {
            super(field);
            this.target = target;
        }

        @Override
        protected Object resolveValue(AbstractBeanFactory beanFactory) {
            return beanFactory.getBeanSupplier(this.target);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ObjectSupplierPropertySetter)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ObjectSupplierPropertySetter that = (ObjectSupplierPropertySetter)o;
            return Objects.equals(this.target, that.target);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.target);
        }

        @Override
        public String toString() {
            return "ObjectSupplierPropertyValue{target=" + this.target + '}';
        }
    }
}

