/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.loader;

import cn.taketoday.context.Ordered;
import cn.taketoday.context.OrderedSupport;
import cn.taketoday.context.factory.BeanFactory;
import cn.taketoday.context.factory.ObjectSupplier;
import cn.taketoday.context.loader.ExecutableParameterResolver;
import cn.taketoday.context.utils.ResolvableType;
import java.lang.reflect.Parameter;
import java.util.function.Supplier;

public class ObjectSupplierParameterResolver
extends OrderedSupport
implements ExecutableParameterResolver,
Ordered {
    public ObjectSupplierParameterResolver() {
        this(Integer.MAX_VALUE);
    }

    public ObjectSupplierParameterResolver(int order) {
        super(order);
    }

    @Override
    public boolean supports(Parameter parameter) {
        Class<?> type = parameter.getType();
        return type == ObjectSupplier.class || type == Supplier.class;
    }

    @Override
    public ObjectSupplier<?> resolve(Parameter parameter, BeanFactory beanFactory) {
        ResolvableType parameterType = ResolvableType.forParameter(parameter);
        if (parameterType.hasGenerics()) {
            ResolvableType generic = parameterType.as(Supplier.class).getGeneric(0);
            return beanFactory.getBeanSupplier(generic.toClass());
        }
        throw new UnsupportedOperationException("Unsupported '" + parameter + "' In -> " + parameter.getDeclaringExecutable());
    }
}

