/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.loader;

import cn.taketoday.context.exception.ConfigurationException;
import cn.taketoday.context.utils.Assert;
import cn.taketoday.context.utils.ClassUtils;
import cn.taketoday.context.utils.GenericTypeResolver;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;

public interface AnnotationCapable<A extends Annotation> {
    default public A getAnnotation() {
        return this.getAnnotation(this.getClass());
    }

    default public A getAnnotation(AnnotatedElement annotated) {
        Assert.notNull((Object)annotated, "annotated must not be null");
        Class generic = GenericTypeResolver.resolveTypeArgument(this.getClass(), AnnotationCapable.class);
        if (generic != null) {
            return (A)ClassUtils.getAnnotation(generic, annotated);
        }
        throw new ConfigurationException("Cannot get target annotation on " + annotated);
    }
}

