/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.io;

import cn.taketoday.context.Constant;
import cn.taketoday.context.io.JarResource;
import cn.taketoday.context.io.UrlBasedResource;
import cn.taketoday.context.utils.ResourceUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Objects;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;

public class JarEntryResource
extends UrlBasedResource
implements JarResource {
    private final String name;
    private final File jarFile;

    public JarEntryResource(URL url) {
        this(url, new File(JarEntryResource.getJarFilePath(url.getPath())), JarEntryResource.getJarEntryName(url.getPath()));
    }

    public JarEntryResource(String path) throws IOException {
        this(new URL(JarEntryResource.getJarUrl(path)), new File(JarEntryResource.getJarFilePath(path)), JarEntryResource.getJarEntryName(path));
    }

    public JarEntryResource(URL url, File jarFile, String name) {
        super(url);
        this.name = Objects.requireNonNull(name, "name");
        this.jarFile = Objects.requireNonNull(jarFile, "jarFile");
    }

    protected static String getJarUrl(String path) {
        if (path.startsWith("jar:file:")) {
            return path;
        }
        String concat = "jar:file:".concat(path);
        if (concat.endsWith("!/")) {
            return concat;
        }
        return concat.concat("!/");
    }

    protected static String getJarFilePath(String path) {
        int indexOf = path.indexOf("!/");
        if (path.startsWith("file:")) {
            return indexOf == -1 ? path.substring(5) : path.substring(5, indexOf);
        }
        return indexOf == -1 ? path : path.substring(0, indexOf);
    }

    private static String getJarEntryName(String path) {
        int indexOf = path.indexOf("!/");
        if (indexOf == -1) {
            return "";
        }
        if (path.charAt(0) == '/') {
            return path.substring(1);
        }
        return path.substring(indexOf + 2);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        String name = this.name;
        if (name.isEmpty()) {
            return new FileInputStream(this.jarFile);
        }
        JarFile jarFile = this.getJarFile();
        return new JarEntryInputStream(jarFile.getInputStream(jarFile.getEntry(name)), jarFile);
    }

    @Override
    public JarOutputStream getOutputStream() throws IOException {
        return new JarOutputStream(Files.newOutputStream(this.getFile().toPath(), new OpenOption[0]));
    }

    @Override
    public File getFile() {
        return this.jarFile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean exists() {
        String name = this.name;
        if (name.isEmpty()) {
            return this.jarFile.exists();
        }
        try (JarFile jarFile = this.getJarFile();){
            boolean bl = jarFile.getEntry(name) != null;
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public boolean isDirectory() throws IOException {
        try (JarFile jarFile = this.getJarFile();){
            boolean bl = jarFile.getEntry(this.name).isDirectory();
            return bl;
        }
    }

    @Override
    public String[] list() throws IOException {
        try (JarFile jarFile = this.getJarFile();){
            String[] stringArray;
            String name = this.name;
            HashSet<String> result = new HashSet<String>();
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry jarEntry = entries.nextElement();
                String entryName = jarEntry.getName();
                if (entryName.equals(name) || !entryName.startsWith(name)) continue;
                String substring = entryName.substring(name.length());
                int index = substring.indexOf(47);
                if (index > -1) {
                    result.add(substring.substring(0, index));
                    continue;
                }
                result.add(substring);
            }
            if (result.isEmpty()) {
                stringArray = Constant.EMPTY_STRING_ARRAY;
                return stringArray;
            }
            stringArray = result.toArray(new String[result.size()]);
            return stringArray;
        }
    }

    @Override
    public JarEntryResource createRelative(String relativePath) throws IOException {
        return new JarEntryResource(new URL(this.getLocation(), relativePath), this.getFile(), ResourceUtils.getRelativePath(this.name, relativePath));
    }

    @Override
    public String toString() {
        return "JarEntryResource: ".concat(this.getLocation().toString());
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof JarEntryResource) {
            return Objects.equals(((JarEntryResource)other).name, this.name) && Objects.equals(((JarEntryResource)other).jarFile, this.jarFile);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.name, this.jarFile);
    }

    private static class JarEntryInputStream
    extends FilterInputStream {
        private final JarFile jarFile;

        protected JarEntryInputStream(InputStream in, JarFile jarFile) {
            super(in);
            this.jarFile = jarFile;
        }

        @Override
        public void close() throws IOException {
            this.in.close();
            this.jarFile.close();
        }
    }
}

