/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.io;

import cn.taketoday.context.Constant;
import cn.taketoday.context.io.Resource;
import cn.taketoday.context.io.ResourceFilter;
import cn.taketoday.context.logger.Logger;
import cn.taketoday.context.logger.LoggerFactory;
import cn.taketoday.context.utils.ResourceUtils;
import cn.taketoday.context.utils.StringUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Objects;

public abstract class AbstractResource
implements Resource {
    @Override
    public String getName() {
        try {
            return this.getFile().getName();
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean exists() {
        try (InputStream inputStream = this.getInputStream();){
            boolean bl = inputStream != null;
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public boolean isReadable() {
        try {
            HttpURLConnection httpCon;
            int code;
            URL url = this.getLocation();
            if (ResourceUtils.isFileURL(url)) {
                File file = this.getFile();
                return file.canRead() && !file.isDirectory();
            }
            URLConnection con = url.openConnection();
            this.customizeConnection(con);
            if (con instanceof HttpURLConnection && (code = (httpCon = (HttpURLConnection)con).getResponseCode()) != 200) {
                httpCon.disconnect();
                return false;
            }
            long contentLength = con.getContentLengthLong();
            if (contentLength > 0L) {
                return true;
            }
            if (contentLength == 0L) {
                return false;
            }
            this.getInputStream().close();
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    protected void customizeConnection(URLConnection con) throws IOException {
        ResourceUtils.useCachesIfNecessary(con);
        if (con instanceof HttpURLConnection) {
            this.customizeConnection((HttpURLConnection)con);
        }
    }

    protected void customizeConnection(HttpURLConnection con) throws IOException {
        con.setRequestMethod("HEAD");
    }

    @Override
    public boolean isOpen() {
        return false;
    }

    @Override
    public URL getLocation() throws IOException {
        throw new FileNotFoundException(this + " cannot be resolved to URL");
    }

    @Override
    public URI getURI() throws IOException {
        URL location = this.getLocation();
        try {
            return location.toURI();
        }
        catch (URISyntaxException ex) {
            throw new IOException("Invalid URI [" + location + "]", ex);
        }
    }

    @Override
    public File getFile() throws IOException {
        throw new FileNotFoundException(this + " cannot be resolved to absolute file path");
    }

    @Override
    public boolean isDirectory() throws IOException {
        return this.getFile().isDirectory();
    }

    @Override
    public String[] list() throws IOException {
        return this.getFile().list();
    }

    @Override
    public Resource[] list(ResourceFilter filter) throws IOException {
        String[] names = this.list();
        if (StringUtils.isArrayEmpty(names)) {
            return Constant.EMPTY_RESOURCE_ARRAY;
        }
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (String name : names) {
            Resource resource = this.createRelative(name);
            if (filter != null && !filter.accept(resource)) continue;
            resources.add(resource);
        }
        if (resources.isEmpty()) {
            return Constant.EMPTY_RESOURCE_ARRAY;
        }
        return resources.toArray(new Resource[resources.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long contentLength() throws IOException {
        InputStream is = this.getInputStream();
        try {
            int read;
            long size = 0L;
            byte[] buf = new byte[256];
            while ((read = is.read(buf)) != -1) {
                size += (long)read;
            }
            long l = size;
            return l;
        }
        finally {
            block8: {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    Logger logger = LoggerFactory.getLogger(this.getClass());
                    if (!logger.isDebugEnabled()) break block8;
                    logger.debug("Could not close content-length InputStream for " + this, ex);
                }
            }
        }
    }

    @Override
    public long lastModified() throws IOException {
        File fileToCheck = this.getFileForLastModifiedCheck();
        long lastModified = fileToCheck.lastModified();
        if (lastModified == 0L && !fileToCheck.exists()) {
            throw new FileNotFoundException(this + " cannot be resolved in the file system for checking its last-modified timestamp");
        }
        return lastModified;
    }

    protected File getFileForLastModifiedCheck() throws IOException {
        return this.getFile();
    }

    @Override
    public Resource createRelative(String relativePath) throws IOException {
        throw new FileNotFoundException(this + " cannot be resolved relative file path for " + relativePath);
    }

    public String toString() {
        try {
            StringBuilder builder = new StringBuilder();
            builder.append("{\n\t\"name\":\"");
            builder.append(this.getName());
            builder.append("\",\n\t\"exists\":\"");
            builder.append(this.exists());
            builder.append("\",\n\t\"location\":\"");
            builder.append(this.getLocation());
            builder.append("\",\n\t\"file\":\"");
            builder.append(this.getFile());
            builder.append("\"\n}");
            return builder.toString();
        }
        catch (IOException e) {
            return super.toString();
        }
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof AbstractResource && Objects.equals(this.toString(), obj.toString());
    }
}

