/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.factory;

import cn.taketoday.context.cglib.proxy.Enhancer;
import cn.taketoday.context.factory.BeanDefinition;
import cn.taketoday.context.factory.ConfigurableBeanFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public final class Prototypes {
    private final BeanDefinition def;
    private final ConfigurableBeanFactory factory;

    private Prototypes(ConfigurableBeanFactory factory, BeanDefinition def) {
        this.def = def;
        this.factory = factory;
    }

    private Object handle(Method method, Object[] a) throws Throwable {
        Object bean = this.factory.getBean(this.def);
        try {
            Object object = method.invoke(bean, a);
            return object;
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
        finally {
            if (this.factory.isFullLifecycle()) {
                this.factory.destroyBean(bean, this.def);
            }
        }
    }

    public static Object newProxyInstance(Class<?> refType, BeanDefinition def, ConfigurableBeanFactory factory) {
        return Prototypes.newProxyInstance(refType, def, factory, false);
    }

    public static Object newProxyInstance(Class<?> refType, BeanDefinition def, ConfigurableBeanFactory factory, boolean proxyTargetClass) {
        Prototypes handler = new Prototypes(factory, def);
        if (!proxyTargetClass && refType.isInterface()) {
            return Proxy.newProxyInstance(refType.getClassLoader(), def.getBeanClass().getInterfaces(), (Object p, Method m, Object[] a) -> handler.handle(m, a));
        }
        return new Enhancer().setUseCache(true).setSuperclass(refType).setInterfaces(refType.getInterfaces()).setClassLoader(refType.getClassLoader()).setCallback((obj, m, a, proxy) -> handler.handle(m, a)).create();
    }
}

