/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.factory;

import cn.taketoday.context.AttributeAccessorSupport;
import cn.taketoday.context.exception.NoSuchPropertyException;
import cn.taketoday.context.factory.AbstractBeanFactory;
import cn.taketoday.context.factory.BeanDefinition;
import cn.taketoday.context.factory.BeanFactory;
import cn.taketoday.context.factory.FactoryBean;
import cn.taketoday.context.factory.FactoryBeanSupplier;
import cn.taketoday.context.factory.PropertySetter;
import cn.taketoday.context.utils.Assert;
import cn.taketoday.context.utils.ContextUtils;
import cn.taketoday.context.utils.SingletonSupplier;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.function.Supplier;

public class FactoryBeanDefinition<T>
extends AttributeAccessorSupport
implements BeanDefinition {
    private final BeanDefinition factoryDef;
    private Supplier<FactoryBean<T>> factorySupplier;

    public FactoryBeanDefinition(String name, Class<?> factoryClass, FactoryBean<T> factoryBean) {
        this(ContextUtils.createBeanDefinition(name, factoryClass), SingletonSupplier.of(factoryBean));
    }

    public FactoryBeanDefinition(String name, Class<?> factoryClass, Supplier<FactoryBean<T>> factorySupplier) {
        this(ContextUtils.createBeanDefinition(name, factoryClass), factorySupplier);
    }

    public FactoryBeanDefinition(BeanDefinition factoryDef, AbstractBeanFactory beanFactory) {
        this(factoryDef, new FactoryBeanSupplier(factoryDef, beanFactory));
    }

    public FactoryBeanDefinition(BeanDefinition factoryDef, Supplier<FactoryBean<T>> factorySupplier) {
        Assert.notNull((Object)factoryDef, "factory BeanDefinition cannot be null");
        this.factoryDef = factoryDef;
        this.factorySupplier = factorySupplier;
    }

    public FactoryBeanDefinition(String name, Class<T> factoryClass, AbstractBeanFactory beanFactory) {
        this.factoryDef = beanFactory.getBeanDefinitionLoader().createBeanDefinition(name, factoryClass);
        this.factorySupplier = new FactoryBeanSupplier(this.factoryDef, beanFactory);
    }

    public Class<T> getBeanClass() {
        return this.getFactory().getBeanClass();
    }

    @Override
    public String getName() {
        return this.factoryDef.getName();
    }

    @Override
    public final boolean isFactoryBean() {
        return true;
    }

    public T getBean() {
        return this.getFactory().getBean();
    }

    public FactoryBean<T> getFactory() {
        Supplier<FactoryBean<T>> supplier = this.getFactorySupplier();
        Assert.state(supplier != null, "factorySupplier must not be null");
        FactoryBean<T> obj = supplier.get();
        Assert.state(obj != null, "The provided FactoryBean cannot be null");
        return obj;
    }

    public void setFactory(FactoryBean<T> factory) {
        this.factorySupplier = SingletonSupplier.of(factory);
    }

    public void setFactorySupplier(Supplier<FactoryBean<T>> supplier) {
        this.factorySupplier = supplier;
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
        return this.factoryDef.getAnnotation(annotationClass);
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.factoryDef.getAnnotations();
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return this.factoryDef.getDeclaredAnnotations();
    }

    @Override
    public PropertySetter getPropertyValue(String name) throws NoSuchPropertyException {
        return this.factoryDef.getPropertyValue(name);
    }

    @Override
    public boolean isSingleton() {
        return this.factoryDef.isSingleton();
    }

    @Override
    public boolean isPrototype() {
        return this.factoryDef.isPrototype();
    }

    @Override
    public Method[] getInitMethods() {
        return this.factoryDef.getInitMethods();
    }

    @Override
    public String[] getDestroyMethods() {
        return this.factoryDef.getDestroyMethods();
    }

    @Override
    public String getScope() {
        return this.factoryDef.getScope();
    }

    @Override
    public boolean isInitialized() {
        return this.factoryDef.isInitialized();
    }

    @Override
    public boolean isAbstract() {
        return this.factoryDef.isAbstract();
    }

    @Override
    public PropertySetter[] getPropertySetters() {
        return this.factoryDef.getPropertySetters();
    }

    @Override
    public void addPropertyValue(String name, Object value) {
        this.factoryDef.addPropertyValue(name, value);
    }

    @Override
    public void addPropertySetter(PropertySetter ... propertySetters) {
        this.factoryDef.addPropertySetter(propertySetters);
    }

    @Override
    public void addPropertySetter(Collection<PropertySetter> propertySetters) {
        this.factoryDef.addPropertySetter(propertySetters);
    }

    @Override
    public FactoryBeanDefinition<T> setInitialized(boolean initialized) {
        this.factoryDef.setInitialized(initialized);
        return this;
    }

    @Override
    public BeanDefinition setName(String name) {
        this.factoryDef.setName(name);
        return this;
    }

    @Override
    public FactoryBeanDefinition<T> setScope(String scope) {
        this.factoryDef.setScope(scope);
        return this;
    }

    @Override
    public BeanDefinition setInitMethods(Method ... initMethods) {
        this.factoryDef.setInitMethods(initMethods);
        return this;
    }

    @Override
    public FactoryBeanDefinition<T> setDestroyMethods(String ... destroyMethods) {
        this.factoryDef.setDestroyMethods(destroyMethods);
        return this;
    }

    @Override
    public FactoryBeanDefinition<T> setPropertyValues(PropertySetter ... propertySetters) {
        this.factoryDef.setPropertyValues(propertySetters);
        return this;
    }

    @Override
    public FactoryBeanDefinition<T> setFactoryBean(boolean factoryBean) {
        return this;
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotation) {
        return this.factoryDef.isAnnotationPresent(annotation);
    }

    @Override
    public BeanDefinition getChild() {
        return this.factoryDef.getChild();
    }

    @Override
    public FactoryBeanDefinition<T> setInitMethods(String ... initMethods) {
        this.factoryDef.setInitMethods(initMethods);
        return this;
    }

    @Override
    public Object newInstance(BeanFactory factory) {
        return this.factoryDef.newInstance(factory);
    }

    @Override
    public Object newInstance(BeanFactory factory, Object ... args) {
        return this.factoryDef.newInstance(factory, args);
    }

    @Override
    public boolean isLazyInit() {
        return this.factoryDef.isLazyInit();
    }

    @Override
    public void copy(BeanDefinition newDef) {
        this.factoryDef.copy(newDef);
    }

    @Override
    public void setLazyInit(boolean lazyInit) {
        this.factoryDef.setLazyInit(lazyInit);
    }

    public Supplier<FactoryBean<T>> getFactorySupplier() {
        return this.factorySupplier;
    }

    public final BeanDefinition getFactoryDefinition() {
        return this.factoryDef;
    }
}

