/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.factory;

import cn.taketoday.context.AttributeAccessorSupport;
import cn.taketoday.context.Constant;
import cn.taketoday.context.Ordered;
import cn.taketoday.context.exception.NoSuchPropertyException;
import cn.taketoday.context.factory.BeanDefinition;
import cn.taketoday.context.factory.BeanFactory;
import cn.taketoday.context.factory.DefaultPropertySetter;
import cn.taketoday.context.factory.PropertySetter;
import cn.taketoday.context.reflect.BeanConstructor;
import cn.taketoday.context.reflect.MethodInvoker;
import cn.taketoday.context.utils.Assert;
import cn.taketoday.context.utils.ClassUtils;
import cn.taketoday.context.utils.CollectionUtils;
import cn.taketoday.context.utils.ContextUtils;
import cn.taketoday.context.utils.ObjectUtils;
import cn.taketoday.context.utils.OrderUtils;
import cn.taketoday.context.utils.ReflectionUtils;
import cn.taketoday.context.utils.StringUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;

public class DefaultBeanDefinition
extends AttributeAccessorSupport
implements BeanDefinition,
Ordered {
    private String name;
    private Class<?> beanClass;
    private String scope;
    private Method[] initMethods = EMPTY_METHOD;
    private String[] destroyMethods = Constant.EMPTY_STRING_ARRAY;
    private PropertySetter[] propertySetters = EMPTY_PROPERTY_VALUE;
    private boolean initialized = false;
    private boolean factoryBean = false;
    private BeanDefinition childDef;
    private Executable executable;
    private BeanConstructor<?> constructor;
    private Boolean lazyInit;
    private MethodInvoker[] methodInvokers;

    public DefaultBeanDefinition(String name, Class<?> beanClass) {
        this.setName(name);
        this.setBeanClass(beanClass);
    }

    public DefaultBeanDefinition(String beanName, BeanDefinition childDef) {
        this.copy(childDef);
        this.setName(beanName);
        this.setChild(childDef);
    }

    @Override
    public PropertySetter getPropertyValue(String name) {
        for (PropertySetter propertySetter : this.propertySetters) {
            if (!propertySetter.getName().equals(name)) continue;
            return propertySetter;
        }
        throw new NoSuchPropertyException("No such property named: [" + name + "]");
    }

    @Override
    public boolean isSingleton() {
        String scope = this.getScope();
        return StringUtils.isEmpty(scope) || "singleton".equals(scope);
    }

    @Override
    public boolean isPrototype() {
        return "prototype".equals(this.scope);
    }

    @Override
    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public void setBeanClass(Class<?> beanClass) {
        this.beanClass = beanClass;
    }

    @Override
    public Method[] getInitMethods() {
        return this.initMethods;
    }

    @Override
    public String[] getDestroyMethods() {
        return this.destroyMethods;
    }

    @Override
    public String getScope() {
        return this.scope;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isFactoryBean() {
        return this.factoryBean;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public boolean isAbstract() {
        return this.childDef != null;
    }

    @Override
    public PropertySetter[] getPropertySetters() {
        return this.propertySetters;
    }

    @Override
    public BeanDefinition setInitialized(boolean initialized) {
        this.initialized = initialized;
        return this;
    }

    @Override
    public BeanDefinition setFactoryBean(boolean factoryBean) {
        this.factoryBean = factoryBean;
        return this;
    }

    @Override
    public BeanDefinition setName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public BeanDefinition setScope(String scope) {
        this.scope = scope;
        return this;
    }

    @Override
    public BeanDefinition setInitMethods(Method ... initMethods) {
        if (ObjectUtils.isNotEmpty(initMethods)) {
            this.initMethods = initMethods;
            this.methodInvokers = new MethodInvoker[initMethods.length];
            int i = 0;
            for (Method initMethod : initMethods) {
                this.methodInvokers[i++] = MethodInvoker.create(initMethod);
            }
        } else {
            this.initMethods = EMPTY_METHOD;
            this.methodInvokers = null;
        }
        return this;
    }

    @Override
    public BeanDefinition setInitMethods(String ... initMethods) {
        return this.setInitMethods(ContextUtils.resolveInitMethod(initMethods, this.obtainBeanClass()));
    }

    @Override
    public BeanDefinition setDestroyMethods(String ... destroyMethods) {
        this.destroyMethods = destroyMethods;
        return this;
    }

    @Override
    public BeanDefinition setPropertyValues(PropertySetter ... propertySetters) {
        this.propertySetters = propertySetters;
        return this;
    }

    @Override
    public void addPropertyValue(String name, Object value) {
        Assert.notNull((Object)name, "property name must not be null");
        Field field = ReflectionUtils.findField(this.obtainBeanClass(), name);
        if (field == null) {
            throw new IllegalArgumentException("property '" + name + "' not found");
        }
        DefaultPropertySetter propertyValue = new DefaultPropertySetter(value, field);
        this.addPropertySetter(propertyValue);
    }

    @Override
    public void addPropertySetter(PropertySetter ... setters) {
        if (ObjectUtils.isNotEmpty(setters)) {
            Object[] propertySetters = this.getPropertySetters();
            if (ObjectUtils.isEmpty(propertySetters)) {
                this.setPropertyValues(setters);
            } else {
                ArrayList pool = new ArrayList(setters.length + propertySetters.length);
                Collections.addAll(pool, setters);
                Collections.addAll(pool, propertySetters);
                this.setPropertyValues(pool.toArray(new PropertySetter[pool.size()]));
            }
        }
    }

    @Override
    public void addPropertySetter(Collection<PropertySetter> newValues) {
        if (CollectionUtils.isEmpty(newValues)) {
            return;
        }
        Object[] propertySetters = this.getPropertySetters();
        if (ObjectUtils.isNotEmpty(propertySetters)) {
            Collections.addAll(newValues, propertySetters);
        }
        this.setPropertyValues(newValues.toArray(new PropertySetter[newValues.size()]));
    }

    @Override
    public int getOrder() {
        return OrderUtils.getOrder(this.getBeanClass());
    }

    @Override
    public BeanDefinition getChild() {
        return this.childDef;
    }

    public DefaultBeanDefinition setChild(BeanDefinition childDef) {
        this.childDef = childDef;
        return this;
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotation) {
        return ClassUtils.isAnnotationPresent(this.getBeanClass(), annotation);
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return ClassUtils.getAnnotation(annotationClass, this.getBeanClass());
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.getBeanClass().getAnnotations();
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return this.getBeanClass().getDeclaredAnnotations();
    }

    public BeanConstructor<?> getConstructor(BeanFactory factory) {
        if (this.constructor == null) {
            this.constructor = this.createConstructor(factory);
        }
        return this.constructor;
    }

    protected BeanConstructor<?> createConstructor(BeanFactory factory) {
        return ReflectionUtils.newConstructor(this.getBeanClass());
    }

    public Executable getExecutable() {
        if (this.executable == null) {
            this.executable = ClassUtils.getSuitableConstructor(this.getBeanClass());
        }
        return this.executable;
    }

    @Override
    public Object newInstance(BeanFactory factory) {
        BeanConstructor<?> target = this.getConstructor(factory);
        Object[] args = ContextUtils.resolveParameter(this.getExecutable(), factory);
        return target.newInstance(args);
    }

    @Override
    public Object newInstance(BeanFactory factory, Object ... args) {
        BeanConstructor<?> target = this.getConstructor(factory);
        return target.newInstance(args);
    }

    public final void fastInvokeInitMethods(Object bean, BeanFactory beanFactory) {
        Object[] methodInvokers = this.methodInvokers;
        if (ObjectUtils.isNotEmpty(methodInvokers)) {
            for (Object methodInvoker : methodInvokers) {
                Object[] args = ContextUtils.resolveParameter(((MethodInvoker)methodInvoker).getMethod(), beanFactory);
                ((MethodInvoker)methodInvoker).invoke(bean, args);
            }
        }
    }

    @Override
    public void setLazyInit(boolean lazyInit) {
        this.lazyInit = lazyInit;
    }

    @Override
    public boolean isLazyInit() {
        return this.lazyInit != null && this.lazyInit != false;
    }

    public Boolean getLazyInit() {
        return this.lazyInit;
    }

    @Override
    public void copy(BeanDefinition newDef) {
        this.setName(newDef.getName());
        this.setChild(newDef.getChild());
        this.setScope(newDef.getScope());
        this.setBeanClass(newDef.getBeanClass());
        this.setFactoryBean(newDef.isFactoryBean());
        this.setInitMethods(newDef.getInitMethods());
        this.setDestroyMethods(newDef.getDestroyMethods());
        this.setPropertyValues(newDef.getPropertySetters());
        this.setLazyInit(newDef.isLazyInit());
        this.setInitialized(newDef.isInitialized());
        this.copyAttributesFrom(newDef);
    }

    Class<?> obtainBeanClass() {
        Class<?> beanClass = this.getBeanClass();
        Assert.state(beanClass != null, "Bean Class is Null");
        return beanClass;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof DefaultBeanDefinition) {
            DefaultBeanDefinition other = (DefaultBeanDefinition)obj;
            return Objects.equals(this.name, other.name) && this.lazyInit == other.lazyInit && this.beanClass == other.beanClass && Objects.equals(this.scope, other.scope) && Objects.equals(this.childDef, other.childDef) && Objects.deepEquals(this.initMethods, other.initMethods) && Objects.deepEquals(this.destroyMethods, other.destroyMethods) && Objects.deepEquals(this.propertySetters, other.propertySetters);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.beanClass, this.lazyInit, this.scope);
    }

    public String toString() {
        return "{\n\t\"name\":\"" + this.name + "\",\n\t\"scope\":\"" + this.scope + "\",\n\t\"beanClass\":\"" + this.beanClass + "\",\n\t\"initMethods\":\"" + Arrays.toString(this.initMethods) + "\",\n\t\"destroyMethods\":\"" + Arrays.toString(this.destroyMethods) + "\",\n\t\"propertyValues\":\"" + Arrays.toString(this.propertySetters) + "\",\n\t\"initialized\":\"" + this.initialized + "\",\n\t\"factoryBean\":\"" + this.factoryBean + "\",\n\t\"child\":\"" + this.childDef + "\"\n}";
    }
}

