/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.factory;

import cn.taketoday.context.conversion.ConversionService;
import cn.taketoday.context.factory.BeanMetadata;
import cn.taketoday.context.factory.BeanProperty;
import cn.taketoday.context.factory.BeanPropertyAccessor;
import cn.taketoday.context.factory.PropertyValue;
import java.beans.PropertyEditor;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class DataBinder
extends BeanPropertyAccessor {
    protected final LinkedList<PropertyValue> propertyValues = new LinkedList();

    public DataBinder() {
    }

    public DataBinder(Class<?> beanClass) {
        super(beanClass);
    }

    public DataBinder(Class<?> beanClass, ConversionService conversionService) {
        super(beanClass, conversionService);
    }

    public DataBinder(Object object) {
        super(BeanMetadata.ofClass(object.getClass()), object);
    }

    public DataBinder(BeanMetadata metadata, Object object) {
        super(metadata, object);
    }

    public Object bind() {
        return this.bind(this.propertyValues);
    }

    public Object bind(List<PropertyValue> propertyValues) {
        return this.bind(this.getRootObject(), propertyValues);
    }

    public Object bind(Object rootObject, List<PropertyValue> propertyValues) {
        return this.bind(rootObject, this.getMetadata(), propertyValues);
    }

    public Object bind(Object rootObject, BeanMetadata metadata, List<PropertyValue> propertyValues) {
        for (PropertyValue propertyValue : propertyValues) {
            this.setProperty(rootObject, metadata, propertyValue);
        }
        return rootObject;
    }

    public void setProperty(Object root, BeanMetadata metadata, PropertyValue propertyValue) {
        this.setProperty(root, metadata, propertyValue.getName(), propertyValue.getValue());
    }

    @Override
    protected Object doConvertInternal(Object value, BeanProperty beanProperty) {
        PropertyEditor editor = this.findEditor(beanProperty);
        if (editor != null && value instanceof String) {
            try {
                editor.setAsText((String)value);
                return editor.getValue();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return super.doConvertInternal(value, beanProperty);
    }

    protected PropertyEditor findEditor(BeanProperty beanProperty) {
        return null;
    }

    public void addPropertyValue(String name, Object value) {
        this.addPropertyValue(new PropertyValue(name, value));
    }

    public void addPropertyValue(PropertyValue propertyValue) {
        this.propertyValues.add(propertyValue);
    }

    public void addPropertyValues(PropertyValue ... propertyValues) {
        Collections.addAll(this.propertyValues, propertyValues);
    }

    public void addPropertyValues(List<PropertyValue> propertyValues) {
        this.propertyValues.addAll(propertyValues);
    }

    public void addPropertyValues(Map<String, Object> propertyValues) {
        propertyValues.forEach(this::addPropertyValue);
    }

    public List<PropertyValue> getPropertyValues() {
        return this.propertyValues;
    }
}

