/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.factory;

import cn.taketoday.context.exception.NoSuchBeanDefinitionException;
import cn.taketoday.context.factory.AbstractBeanFactory;
import cn.taketoday.context.factory.AbstractPropertySetter;
import cn.taketoday.context.factory.BeanDefinition;
import cn.taketoday.context.factory.BeanReference;
import cn.taketoday.context.factory.Prototypes;
import java.lang.reflect.Field;
import java.util.Objects;

public class BeanReferencePropertySetter
extends AbstractPropertySetter {
    private final BeanReference reference;

    public BeanReferencePropertySetter(BeanReference value, Field field) {
        super(field);
        this.reference = value;
    }

    @Override
    protected Object resolveValue(AbstractBeanFactory beanFactory) {
        BeanReference reference = this.reference;
        Object value = this.resolveBeanReference(beanFactory, reference);
        if (value == null) {
            if (reference.isRequired()) {
                throw new NoSuchBeanDefinitionException(reference.getName(), reference.getReferenceClass());
            }
            return DO_NOT_SET;
        }
        return value;
    }

    protected Object resolveBeanReference(AbstractBeanFactory beanFactory, BeanReference ref) {
        String name = ref.getName();
        Class<?> type = ref.getReferenceClass();
        if (beanFactory.isFullPrototype() && ref.isPrototype() && beanFactory.containsBeanDefinition(name)) {
            return Prototypes.newProxyInstance(type, beanFactory.getBeanDefinition(name), beanFactory);
        }
        BeanDefinition reference = ref.getReference();
        if (reference != null) {
            return beanFactory.getBean(reference);
        }
        Object bean = beanFactory.getBean(name, type);
        return bean != null ? bean : beanFactory.doGetBeanForType(type);
    }

    public BeanReference getReference() {
        return this.reference;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BeanReferencePropertySetter)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BeanReferencePropertySetter that = (BeanReferencePropertySetter)o;
        return Objects.equals(this.reference, that.reference);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.reference);
    }
}

