/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.factory;

import cn.taketoday.context.exception.ContextException;
import cn.taketoday.context.factory.BeanDefinition;
import cn.taketoday.context.utils.StringUtils;
import java.lang.reflect.Field;
import java.util.Objects;

public final class BeanReference {
    private final String name;
    private final boolean required;
    private final Class<?> referenceClass;
    private boolean prototype = false;
    private final Field field;
    private BeanDefinition reference;

    public BeanReference(String name, boolean required, Field field) {
        if (StringUtils.isEmpty(name)) {
            throw new ContextException("Bean name can't be empty");
        }
        this.name = name;
        this.field = field;
        this.required = required;
        this.referenceClass = field.getType();
    }

    public String getName() {
        return this.name;
    }

    public boolean isRequired() {
        return this.required;
    }

    public Class<?> getReferenceClass() {
        return this.referenceClass;
    }

    public void applyPrototype() {
        this.prototype = true;
    }

    public boolean isPrototype() {
        return this.prototype;
    }

    public BeanReference setPrototype(boolean prototype) {
        this.prototype = prototype;
        return this;
    }

    public Field getProperty() {
        return this.field;
    }

    public BeanDefinition getReference() {
        return this.reference;
    }

    public void setReference(BeanDefinition reference) {
        this.reference = reference;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.required, this.referenceClass, this.isPrototype());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof BeanReference) {
            BeanReference other = (BeanReference)obj;
            return other.required == this.required && other.isPrototype() == this.isPrototype() && Objects.equals(other.name, this.name) && other.referenceClass == this.referenceClass;
        }
        return false;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{\n\t\"name\":\"");
        builder.append(this.name);
        builder.append("\",\n\t\"required\":\"");
        builder.append(this.required);
        builder.append("\",\n\t\"referenceClass\":\"");
        builder.append(this.referenceClass);
        builder.append("\",\n\t\"field\":\"");
        builder.append(this.field);
        builder.append("\",\n\t\"prototype\":\"");
        builder.append(this.isPrototype());
        builder.append("\"\n}");
        return builder.toString();
    }
}

