/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.factory;

import cn.taketoday.context.annotation.Property;
import cn.taketoday.context.exception.NoSuchPropertyException;
import cn.taketoday.context.factory.BeanProperty;
import cn.taketoday.context.reflect.ConstructorAccessor;
import cn.taketoday.context.reflect.PropertyAccessor;
import cn.taketoday.context.utils.ClassUtils;
import cn.taketoday.context.utils.Mappings;
import cn.taketoday.context.utils.ReflectionUtils;
import cn.taketoday.context.utils.StringUtils;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class BeanMetadata {
    private static final Mappings<BeanMetadata, ?> metadataMappings = new Mappings(BeanMetadata::new);
    private static final BeanPropertiesMappings beanPropertiesMappings = new BeanPropertiesMappings();
    private final Class<?> beanClass;
    private ConstructorAccessor constructor;
    private final Map<String, BeanProperty> beanProperties;

    private BeanMetadata(Object key) {
        this((Class)key);
    }

    public BeanMetadata(Class<?> beanClass) {
        this.beanClass = beanClass;
        this.beanProperties = (Map)beanPropertiesMappings.get(beanClass, this);
    }

    public Class<?> getType() {
        return this.beanClass;
    }

    public ConstructorAccessor getConstructor() {
        if (this.constructor == null) {
            this.constructor = ReflectionUtils.newConstructorAccessor(this.beanClass);
        }
        return this.constructor;
    }

    public Object newInstance() {
        return this.newInstance(null);
    }

    public Object newInstance(Object[] args) {
        return this.getConstructor().newInstance(args);
    }

    public PropertyAccessor getPropertyAccessor(String propertyName) {
        return this.getBeanProperty(propertyName).getPropertyAccessor();
    }

    public BeanProperty getBeanProperty(String propertyName) {
        return this.beanProperties.get(propertyName);
    }

    public BeanProperty obtainBeanProperty(String propertyName) {
        BeanProperty beanProperty = this.getBeanProperty(propertyName);
        if (beanProperty == null) {
            throw NoSuchPropertyException.noSuchProperty(this.beanClass, propertyName);
        }
        return beanProperty;
    }

    public void setProperty(Object root, String propertyName, Object value) {
        this.obtainBeanProperty(propertyName).setValue(root, value);
    }

    public Object getProperty(Object root, String propertyName) {
        return this.obtainBeanProperty(propertyName).getValue(root);
    }

    public Class<?> getPropertyClass(String propertyName) {
        return this.obtainBeanProperty(propertyName).getType();
    }

    public Map<String, BeanProperty> getBeanProperties() {
        return this.beanProperties;
    }

    public Map<String, BeanProperty> createBeanProperties() {
        HashMap<String, BeanProperty> beanPropertyMap = new HashMap<String, BeanProperty>();
        Collection<Field> declaredFields = ReflectionUtils.getFields(this.beanClass);
        for (Field declaredField : declaredFields) {
            if (this.shouldSkip(declaredField)) continue;
            String propertyName = this.getPropertyName(declaredField);
            beanPropertyMap.put(propertyName, new BeanProperty(declaredField));
        }
        return beanPropertyMap;
    }

    protected boolean shouldSkip(Field declaredField) {
        return Modifier.isStatic(declaredField.getModifiers());
    }

    protected String getPropertyName(Field declaredField) {
        String propertyName = this.getAnnotatedPropertyName(declaredField);
        if (propertyName == null) {
            propertyName = declaredField.getName();
        }
        return propertyName;
    }

    protected String getAnnotatedPropertyName(AnnotatedElement propertyElement) {
        String name;
        Property property = ClassUtils.getAnnotation(Property.class, propertyElement);
        if (property != null && StringUtils.isNotEmpty(name = property.value())) {
            return name;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BeanMetadata)) {
            return false;
        }
        BeanMetadata that = (BeanMetadata)o;
        return Objects.equals(this.beanClass, that.beanClass);
    }

    public int hashCode() {
        return Objects.hash(this.beanClass);
    }

    public static BeanMetadata ofClass(Class<?> beanClass) {
        return metadataMappings.get(beanClass);
    }

    public static BeanMetadata ofObject(Object object) {
        return BeanMetadata.ofClass(object.getClass());
    }

    static class BeanPropertiesMappings
    extends Mappings<Map<String, BeanProperty>, BeanMetadata> {
        BeanPropertiesMappings() {
        }

        @Override
        protected Map<String, BeanProperty> createValue(Object key, BeanMetadata param) {
            return param.createBeanProperties();
        }
    }
}

