/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.event;

import cn.taketoday.context.AnnotationAttributes;
import cn.taketoday.context.ConfigurableApplicationContext;
import cn.taketoday.context.event.ApplicationEventCapable;
import cn.taketoday.context.event.ApplicationListener;
import cn.taketoday.context.event.EventListener;
import cn.taketoday.context.exception.ConfigurationException;
import cn.taketoday.context.factory.BeanDefinition;
import cn.taketoday.context.factory.BeanFactory;
import cn.taketoday.context.factory.BeanPostProcessor;
import cn.taketoday.context.factory.ConfigurableBeanFactory;
import cn.taketoday.context.reflect.MethodInvoker;
import cn.taketoday.context.utils.Assert;
import cn.taketoday.context.utils.ClassUtils;
import cn.taketoday.context.utils.ContextUtils;
import cn.taketoday.context.utils.ObjectUtils;
import cn.taketoday.context.utils.ReflectionUtils;
import java.lang.reflect.Method;
import java.util.EventObject;

public class MethodEventDrivenPostProcessor
implements BeanPostProcessor {
    private final ConfigurableApplicationContext context;

    public MethodEventDrivenPostProcessor(ConfigurableApplicationContext context) {
        Assert.notNull((Object)context, "ApplicationContext must not be null");
        this.context = context;
    }

    @Override
    public Object postProcessAfterInitialization(Object bean, BeanDefinition def) {
        Method[] declaredMethods;
        Class<?> beanClass = def.getBeanClass();
        ConfigurableBeanFactory beanFactory = this.context.getBeanFactory();
        for (Method declaredMethod : declaredMethods = ReflectionUtils.getDeclaredMethods(beanClass)) {
            AnnotationAttributes[] attributes;
            if (!ClassUtils.isAnnotationPresent(declaredMethod, EventListener.class)) continue;
            for (AnnotationAttributes attribute : attributes = ClassUtils.getAnnotationAttributesArray(declaredMethod, EventListener.class)) {
                Class<?>[] eventTypes = this.getEventTypes(attribute, declaredMethod);
                this.addListener(bean, beanFactory, declaredMethod, eventTypes);
            }
        }
        return bean;
    }

    Class<?>[] getEventTypes(AnnotationAttributes attribute, Method declaredMethod) {
        Object[] eventTypes = attribute.getClassArray("value");
        if (ObjectUtils.isNotEmpty(eventTypes)) {
            return eventTypes;
        }
        Class<?>[] parameterTypes = declaredMethod.getParameterTypes();
        if (parameterTypes.length == 0) {
            throw new ConfigurationException("cannot determine event type on method: " + declaredMethod);
        }
        if (parameterTypes.length == 1) {
            return new Class[]{parameterTypes[0]};
        }
        Class<?> eventType = null;
        for (Class<?> parameterType : parameterTypes) {
            if (!EventObject.class.isAssignableFrom(parameterType)) continue;
            eventType = parameterType;
            break;
        }
        if (eventType == null) {
            eventType = parameterTypes[0];
        }
        return new Class[]{eventType};
    }

    void addListener(Object bean, ConfigurableBeanFactory beanFactory, Method declaredMethod, Class<?> ... eventTypes) {
        MethodApplicationListener listener = new MethodApplicationListener(bean, declaredMethod, eventTypes, beanFactory);
        this.context.addApplicationListener(listener);
    }

    static class MethodApplicationListener
    implements ApplicationListener<Object>,
    ApplicationEventCapable {
        final Object bean;
        final Method targetMethod;
        final Class<?>[] eventTypes;
        final BeanFactory beanFactory;
        final MethodInvoker methodInvoker;

        MethodApplicationListener(Object bean, Method targetMethod, Class<?>[] eventTypes, BeanFactory beanFactory) {
            this.bean = bean;
            this.eventTypes = eventTypes;
            this.beanFactory = beanFactory;
            this.targetMethod = targetMethod;
            this.methodInvoker = MethodInvoker.create(targetMethod);
        }

        @Override
        public void onApplicationEvent(Object event) {
            Object[] parameter = ContextUtils.resolveParameter(this.targetMethod, this.beanFactory, new Object[]{event});
            this.methodInvoker.invoke(this.bean, parameter);
        }

        @Override
        public Class<?>[] getApplicationEvent() {
            return this.eventTypes;
        }
    }
}

