/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.env;

import cn.taketoday.context.BeanNameCreator;
import cn.taketoday.context.ConcurrentProperties;
import cn.taketoday.context.env.ConfigurableEnvironment;
import cn.taketoday.context.env.DefaultBeanNameCreator;
import cn.taketoday.context.factory.BeanDefinitionRegistry;
import cn.taketoday.context.io.Resource;
import cn.taketoday.context.io.ResourceFilter;
import cn.taketoday.context.loader.BeanDefinitionLoader;
import cn.taketoday.context.logger.Logger;
import cn.taketoday.context.logger.LoggerFactory;
import cn.taketoday.context.utils.ResourceUtils;
import cn.taketoday.context.utils.StringUtils;
import cn.taketoday.expression.ExpressionProcessor;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Properties;

public class StandardEnvironment
implements ConfigurableEnvironment {
    private static final Logger log = LoggerFactory.getLogger(StandardEnvironment.class);
    private final HashSet<String> activeProfiles = new HashSet(4);
    private final ConcurrentProperties properties = new ConcurrentProperties();
    private BeanNameCreator beanNameCreator;
    private BeanDefinitionLoader beanDefinitionLoader;
    private BeanDefinitionRegistry beanDefinitionRegistry;
    private String propertiesLocation = "";
    private ExpressionProcessor expressionProcessor;

    public StandardEnvironment() {
        if (System.getSecurityManager() != null) {
            AccessController.doPrivileged(() -> {
                this.properties.putAll(System.getProperties());
                System.setProperties(this.properties);
                return null;
            });
        } else {
            this.properties.putAll(System.getProperties());
            System.setProperties(this.properties);
        }
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public boolean containsProperty(String key) {
        return this.properties.containsKey(key);
    }

    @Override
    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        return this.properties.getProperty(key, defaultValue);
    }

    @Override
    public BeanDefinitionRegistry getBeanDefinitionRegistry() {
        return this.beanDefinitionRegistry;
    }

    @Override
    public BeanDefinitionLoader getBeanDefinitionLoader() {
        return this.beanDefinitionLoader;
    }

    @Override
    public String[] getActiveProfiles() {
        return StringUtils.toStringArray(this.activeProfiles);
    }

    @Override
    public void setActiveProfiles(String ... profiles) {
        Collections.addAll(this.activeProfiles, profiles);
        log.info("Active profiles: {}", (Object)this.activeProfiles);
    }

    @Override
    public void setProperty(String key, String value) {
        this.properties.setProperty(key, value);
    }

    @Override
    public void addActiveProfile(String profile) {
        log.info("Add active profile: [{}]", (Object)profile);
        this.activeProfiles.add(profile);
    }

    protected void loadProperties(Resource propertiesResource) throws IOException {
        if (!propertiesResource.exists()) {
            log.warn("The resource: [{}] you provided that doesn't exist", (Object)propertiesResource);
            return;
        }
        if (propertiesResource.isDirectory()) {
            log.debug("Start scanning properties resource.");
            ResourceFilter propertiesFileFilter = file -> {
                if (file.isDirectory()) {
                    return true;
                }
                String name = file.getName();
                return name.endsWith(".properties") && !name.startsWith("pom");
            };
            StandardEnvironment.doLoadFromDirectory(propertiesResource, this.properties, propertiesFileFilter);
        } else {
            StandardEnvironment.doLoad(this.properties, propertiesResource);
        }
    }

    @Override
    public void loadProperties(String propertiesLocation) throws IOException {
        this.loadProperties(ResourceUtils.getResource(Objects.requireNonNull(propertiesLocation, "Properties dir can't be null")));
    }

    @Override
    public void loadProperties() throws IOException {
        for (String propertiesLocation : StringUtils.split(this.propertiesLocation)) {
            this.loadProperties(propertiesLocation);
        }
        this.refreshActiveProfiles();
    }

    protected void refreshActiveProfiles() {
        String profiles = this.getProperty("context.active.profiles");
        if (StringUtils.isNotEmpty(profiles)) {
            this.setActiveProfiles(StringUtils.split(profiles));
        }
    }

    public static void doLoadFromDirectory(Resource directory, Properties properties, ResourceFilter propertiesFileFilter) throws IOException {
        Resource[] listResources;
        for (Resource resource : listResources = directory.list(propertiesFileFilter)) {
            if (resource.isDirectory()) {
                StandardEnvironment.doLoadFromDirectory(resource, properties, propertiesFileFilter);
                continue;
            }
            StandardEnvironment.doLoad(properties, resource);
        }
    }

    public static void doLoad(Properties properties, Resource resource) throws IOException {
        if (log.isInfoEnabled()) {
            log.info("Found Properties Resource: [{}]", (Object)resource.getLocation());
        }
        try (InputStream inputStream = resource.getInputStream();){
            properties.load(inputStream);
        }
    }

    @Override
    public ConfigurableEnvironment setBeanDefinitionRegistry(BeanDefinitionRegistry beanDefinitionRegistry) {
        this.beanDefinitionRegistry = beanDefinitionRegistry;
        return this;
    }

    @Override
    public ConfigurableEnvironment setBeanDefinitionLoader(BeanDefinitionLoader beanDefinitionLoader) {
        this.beanDefinitionLoader = beanDefinitionLoader;
        return this;
    }

    @Override
    public boolean acceptsProfiles(String ... profiles) {
        HashSet<String> activeProfiles = this.activeProfiles;
        for (String profile : Objects.requireNonNull(profiles)) {
            if (!(StringUtils.isNotEmpty(profile) && profile.charAt(0) == '!' ? !activeProfiles.contains(profile.substring(1)) : activeProfiles.contains(profile))) continue;
            return true;
        }
        return false;
    }

    @Override
    public ConfigurableEnvironment setBeanNameCreator(BeanNameCreator beanNameCreator) {
        this.beanNameCreator = beanNameCreator;
        return this;
    }

    @Override
    public BeanNameCreator getBeanNameCreator() {
        BeanNameCreator ret = this.beanNameCreator;
        if (ret == null) {
            this.beanNameCreator = this.createBeanNameCreator();
            return this.beanNameCreator;
        }
        return ret;
    }

    protected BeanNameCreator createBeanNameCreator() {
        return new DefaultBeanNameCreator(this);
    }

    @Override
    public ExpressionProcessor getExpressionProcessor() {
        return this.expressionProcessor;
    }

    @Override
    public ConfigurableEnvironment setExpressionProcessor(ExpressionProcessor expressionProcessor) {
        this.expressionProcessor = expressionProcessor;
        return this;
    }

    @Override
    public ConfigurableEnvironment setPropertiesLocation(String propertiesLocation) {
        this.propertiesLocation = propertiesLocation;
        return this;
    }

    public String getPropertiesLocation() {
        return this.propertiesLocation;
    }
}

