/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.env;

import cn.taketoday.context.BeanNameCreator;
import cn.taketoday.context.conversion.Converter;
import cn.taketoday.context.factory.BeanDefinitionRegistry;
import cn.taketoday.context.loader.BeanDefinitionLoader;
import cn.taketoday.context.utils.ConvertUtils;
import cn.taketoday.context.utils.StringUtils;
import cn.taketoday.expression.ExpressionProcessor;
import java.util.Properties;

public interface Environment {
    public Properties getProperties();

    public boolean containsProperty(String var1);

    public String getProperty(String var1);

    public String getProperty(String var1, String var2);

    default public <T> T getProperty(String key, Class<T> targetType) {
        return this.getProperty(key, targetType, null);
    }

    default public <T> T getProperty(String key, Class<T> targetType, T defaultValue) {
        return (T)this.getProperty(key, (S s) -> ConvertUtils.convert(targetType, s), defaultValue);
    }

    default public <S, T> T getProperty(String key, Converter<S, T> converter, T defaultValue) {
        String property = this.getProperty(key);
        if (property == null) {
            return defaultValue;
        }
        return converter.convert(property);
    }

    public String[] getActiveProfiles();

    public boolean acceptsProfiles(String ... var1);

    public BeanNameCreator getBeanNameCreator();

    public BeanDefinitionLoader getBeanDefinitionLoader();

    public BeanDefinitionRegistry getBeanDefinitionRegistry();

    public ExpressionProcessor getExpressionProcessor();

    default public boolean getFlag(String key) {
        return Boolean.parseBoolean(this.getProperty(key));
    }

    default public boolean getFlag(String key, boolean defaultFlag) {
        String property = this.getProperty(key);
        return StringUtils.isEmpty(property) ? defaultFlag : Boolean.parseBoolean(property);
    }
}

