/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.conversion.support;

import cn.taketoday.context.conversion.Converter;
import java.util.HashSet;

final class StringToBooleanConverter
implements Converter<String, Boolean> {
    private static final HashSet<String> trueValues = new HashSet(8);
    private static final HashSet<String> falseValues = new HashSet(8);

    StringToBooleanConverter() {
    }

    @Override
    public Boolean convert(String source) {
        String value = source.trim();
        if (value.isEmpty()) {
            return null;
        }
        if (trueValues.contains(value = value.toLowerCase())) {
            return Boolean.TRUE;
        }
        if (falseValues.contains(value)) {
            return Boolean.FALSE;
        }
        throw new IllegalArgumentException("Invalid boolean value '" + source + "'");
    }

    static {
        trueValues.add("true");
        trueValues.add("on");
        trueValues.add("yes");
        trueValues.add("1");
        falseValues.add("false");
        falseValues.add("off");
        falseValues.add("no");
        falseValues.add("0");
    }
}

