/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.conversion.support;

import cn.taketoday.context.conversion.support.NumberConverter;
import java.util.function.Function;
import java.util.function.UnaryOperator;

public class FunctionNumberConverter
extends NumberConverter {
    final UnaryOperator<Number> convertFunction;
    final Function<String, Number> stringFunction;

    public FunctionNumberConverter(Class<?> type, Function<String, Number> stringFunction, UnaryOperator<Number> convertFunction) {
        super(type);
        this.stringFunction = stringFunction;
        this.convertFunction = convertFunction;
    }

    @Override
    protected Number convertNumber(Number source) {
        return (Number)this.convertFunction.apply(source);
    }

    @Override
    protected Number convertString(String source) {
        String stringVal = source.trim();
        if (stringVal.isEmpty()) {
            return this.convertNull();
        }
        return this.stringFunction.apply(stringVal);
    }
}

