/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.conversion.support;

import cn.taketoday.context.conversion.ConversionService;
import cn.taketoday.context.conversion.support.CollectionSourceConverter;
import cn.taketoday.context.utils.CollectionUtils;
import cn.taketoday.context.utils.GenericDescriptor;
import java.util.Collection;

final class CollectionToCollectionConverter
extends CollectionSourceConverter {
    private final ConversionService conversionService;

    public CollectionToCollectionConverter(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Override
    protected boolean supportsInternal(GenericDescriptor targetType, Class<?> sourceType) {
        return targetType.isCollection();
    }

    @Override
    protected Object convertInternal(GenericDescriptor targetType, Collection<?> sourceCollection) {
        boolean copyRequired;
        boolean bl = copyRequired = !targetType.isInstance(sourceCollection);
        if (!copyRequired && sourceCollection.isEmpty()) {
            return sourceCollection;
        }
        GenericDescriptor elementType = targetType.getGeneric(Collection.class);
        if (elementType == null && !copyRequired) {
            return sourceCollection;
        }
        Collection<Object> target = CollectionUtils.createCollection(targetType.getType(), elementType != null ? elementType.getType() : null, sourceCollection.size());
        if (elementType == null) {
            target.addAll(sourceCollection);
        } else {
            ConversionService conversionService = this.conversionService;
            for (Object sourceElement : sourceCollection) {
                Object targetElement = conversionService.convert(sourceElement, elementType);
                target.add(targetElement);
                if (sourceElement == targetElement) continue;
                copyRequired = true;
            }
        }
        return copyRequired ? target : sourceCollection;
    }
}

