/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.cglib.reflect;

import cn.taketoday.context.Constant;
import cn.taketoday.context.asm.ClassVisitor;
import cn.taketoday.context.asm.Label;
import cn.taketoday.context.asm.Type;
import cn.taketoday.context.cglib.core.Block;
import cn.taketoday.context.cglib.core.CglibCollectionUtils;
import cn.taketoday.context.cglib.core.CglibReflectUtils;
import cn.taketoday.context.cglib.core.ClassEmitter;
import cn.taketoday.context.cglib.core.CodeEmitter;
import cn.taketoday.context.cglib.core.DuplicatesPredicate;
import cn.taketoday.context.cglib.core.EmitUtils;
import cn.taketoday.context.cglib.core.MethodInfo;
import cn.taketoday.context.cglib.core.MethodInfoTransformer;
import cn.taketoday.context.cglib.core.ObjectSwitchCallback;
import cn.taketoday.context.cglib.core.ProcessSwitchCallback;
import cn.taketoday.context.cglib.core.Signature;
import cn.taketoday.context.cglib.core.Transformer;
import cn.taketoday.context.cglib.core.TypeUtils;
import cn.taketoday.context.cglib.core.VisibilityPredicate;
import cn.taketoday.context.cglib.reflect.FastClass;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

class FastClassEmitter
extends ClassEmitter {
    private static final Signature CSTRUCT_CLASS = TypeUtils.parseConstructor("Class");
    private static final Signature METHOD_GET_INDEX = TypeUtils.parseSignature("int getIndex(String, Class[])");
    private static final Signature SIGNATURE_GET_INDEX = new Signature("getIndex", Type.INT_TYPE, new Type[]{Constant.TYPE_SIGNATURE});
    private static final Signature TO_STRING = TypeUtils.parseSignature("String toString()");
    private static final Signature CONSTRUCTOR_GET_INDEX = TypeUtils.parseSignature("int getIndex(Class[])");
    private static final Signature INVOKE = TypeUtils.parseSignature("Object invoke(int, Object, Object[])");
    private static final Signature NEW_INSTANCE = TypeUtils.parseSignature("Object newInstance(int, Object[])");
    private static final Signature GET_MAX_INDEX = TypeUtils.parseSignature("int getMaxIndex()");
    private static final Signature GET_SIGNATURE_WITHOUT_RETURN_TYPE = TypeUtils.parseSignature("String getSignatureWithoutReturnType(String, Class[])");
    private static final Type FAST_CLASS = TypeUtils.parseType(FastClass.class);
    private static final Type ILLEGAL_ARGUMENT_EXCEPTION = TypeUtils.parseType("IllegalArgumentException");
    private static final Type INVOCATION_TARGET_EXCEPTION = TypeUtils.parseType("java.lang.reflect.InvocationTargetException");
    private static final Type[] INVOCATION_TARGET_EXCEPTION_ARRAY = new Type[]{INVOCATION_TARGET_EXCEPTION};
    private static final int TOO_MANY_METHODS = 100;

    public FastClassEmitter(ClassVisitor v, String className, Class type) {
        super(v);
        Type base = Type.getType(type);
        this.beginClass(52, 1, className, FAST_CLASS, null, "<cglibGenerated>");
        CodeEmitter e = this.beginMethod(1, CSTRUCT_CLASS, new Type[0]);
        e.load_this();
        e.load_args();
        e.super_invoke_constructor(CSTRUCT_CLASS);
        e.return_value();
        e.end_method();
        VisibilityPredicate vp = new VisibilityPredicate(type, false);
        List<Method> methods = CglibReflectUtils.addAllMethods(type, new ArrayList<Method>());
        CglibCollectionUtils.filter(methods, vp);
        CglibCollectionUtils.filter(methods, new DuplicatesPredicate());
        ArrayList constructors = new ArrayList();
        Collections.addAll(constructors, type.getDeclaredConstructors());
        CglibCollectionUtils.filter(constructors, vp);
        this.emitIndexBySignature(methods);
        this.emitIndexByClassArray(methods);
        e = this.beginMethod(1, CONSTRUCTOR_GET_INDEX, new Type[0]);
        e.load_args();
        List<MethodInfo> info = CglibCollectionUtils.transform(constructors, MethodInfoTransformer.getInstance());
        EmitUtils.constructorSwitch(e, info, new GetIndexCallback(e, info));
        e.end_method();
        e = this.beginMethod(1, INVOKE, INVOCATION_TARGET_EXCEPTION_ARRAY);
        e.load_arg(1);
        e.checkcast(base);
        e.load_arg(0);
        FastClassEmitter.invokeSwitchHelper(e, methods, 2, base);
        e.end_method();
        e = this.beginMethod(1, NEW_INSTANCE, INVOCATION_TARGET_EXCEPTION_ARRAY);
        e.new_instance(base);
        e.dup();
        e.load_arg(0);
        FastClassEmitter.invokeSwitchHelper(e, constructors, 1, base);
        e.end_method();
        e = this.beginMethod(1, GET_MAX_INDEX, new Type[0]);
        e.push(methods.size() - 1);
        e.return_value();
        e.end_method();
        this.endClass();
    }

    private void emitIndexBySignature(List<Method> methods) {
        CodeEmitter e = this.beginMethod(1, SIGNATURE_GET_INDEX, new Type[0]);
        List<String> signatures = CglibCollectionUtils.transform(methods, new Transformer<Method, String>(){

            @Override
            public String transform(Method obj) {
                return CglibReflectUtils.getSignature(obj).toString();
            }
        });
        e.load_arg(0);
        e.invoke_virtual(Constant.TYPE_OBJECT, TO_STRING);
        this.signatureSwitchHelper(e, signatures);
        e.end_method();
    }

    private void emitIndexByClassArray(List methods) {
        CodeEmitter e = this.beginMethod(1, METHOD_GET_INDEX, new Type[0]);
        if (methods.size() > 100) {
            List<String> signatures = CglibCollectionUtils.transform(methods, new Transformer<Method, String>(){

                @Override
                public String transform(Method obj) {
                    String s = CglibReflectUtils.getSignature(obj).toString();
                    return s.substring(0, s.lastIndexOf(41) + 1);
                }
            });
            e.load_args();
            e.invoke_static(FAST_CLASS, GET_SIGNATURE_WITHOUT_RETURN_TYPE);
            this.signatureSwitchHelper(e, signatures);
        } else {
            e.load_args();
            List<MethodInfo> info = CglibCollectionUtils.transform(methods, MethodInfoTransformer.getInstance());
            EmitUtils.methodSwitch(e, info, new GetIndexCallback(e, info));
        }
        e.end_method();
    }

    private void signatureSwitchHelper(final CodeEmitter e, final List<String> signatures) {
        ObjectSwitchCallback callback = new ObjectSwitchCallback(){

            @Override
            public void processCase(Object key, Label end) {
                e.push(signatures.indexOf(key));
                e.return_value();
            }

            @Override
            public void processDefault() {
                e.push(-1);
                e.return_value();
            }
        };
        EmitUtils.stringSwitch(e, signatures.toArray(new String[signatures.size()]), 1, callback);
    }

    private static void invokeSwitchHelper(final CodeEmitter e, List members, final int arg, final Type base) {
        final List<MethodInfo> info = CglibCollectionUtils.transform(members, MethodInfoTransformer.getInstance());
        final Label illegalArg = e.make_label();
        Block block = e.begin_block();
        e.process_switch(FastClassEmitter.getIntRange(info.size()), new ProcessSwitchCallback(){

            @Override
            public void processCase(int key, Label end) {
                MethodInfo method = (MethodInfo)info.get(key);
                Type[] types = method.getSignature().getArgumentTypes();
                for (int i = 0; i < types.length; ++i) {
                    e.load_arg(arg);
                    e.aaload(i);
                    e.unbox(types[i]);
                }
                e.invoke(method, base);
                if (!TypeUtils.isConstructor(method)) {
                    e.box(method.getSignature().getReturnType());
                }
                e.return_value();
            }

            @Override
            public void processDefault() {
                e.goTo(illegalArg);
            }
        });
        block.end();
        EmitUtils.wrapThrowable(block, INVOCATION_TARGET_EXCEPTION);
        e.mark(illegalArg);
        e.throw_exception(ILLEGAL_ARGUMENT_EXCEPTION, "Cannot find matching method/constructor");
    }

    private static int[] getIntRange(int length) {
        int[] range = new int[length];
        for (int i = 0; i < length; ++i) {
            range[i] = i;
        }
        return range;
    }

    private static class GetIndexCallback
    implements ObjectSwitchCallback {
        private CodeEmitter e;
        private HashMap<Object, Integer> indexes = new HashMap();

        public GetIndexCallback(CodeEmitter e, List methods) {
            this.e = e;
            int index = 0;
            for (Object object : methods) {
                this.indexes.put(object, index++);
            }
        }

        @Override
        public void processCase(Object key, Label end) {
            this.e.push(this.indexes.get(key));
            this.e.return_value();
        }

        @Override
        public void processDefault() {
            this.e.push(-1);
            this.e.return_value();
        }
    }
}

