/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.cglib.proxy;

import cn.taketoday.context.cglib.core.CodeGenerationException;
import cn.taketoday.context.cglib.core.Signature;
import cn.taketoday.context.cglib.proxy.MethodInterceptorGenerator;
import cn.taketoday.context.cglib.reflect.FastClass;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class MethodProxy {
    private final int i1;
    private final int i2;
    private final FastClass f1;
    private final FastClass f2;
    private final Signature sig1;
    private final Signature sig2;

    private MethodProxy(Signature sig1, Signature sig2, int i1, int i2, FastClass f1, FastClass f2) {
        this.sig1 = sig1;
        this.sig2 = sig2;
        this.f1 = f1;
        this.f2 = f2;
        this.i1 = i1;
        this.i2 = i2;
    }

    public static MethodProxy create(Class<?> c1, Class<?> c2, String desc, String name1, String name2) {
        Signature sig1 = new Signature(name1, desc);
        Signature sig2 = new Signature(name2, desc);
        FastClass f1 = FastClass.create(c1);
        FastClass f2 = FastClass.create(c2);
        return new MethodProxy(sig1, sig2, f1.getIndex(sig1), f2.getIndex(sig2), f1, f2);
    }

    public Signature getSignature() {
        return this.sig1;
    }

    public String getSuperName() {
        return this.sig2.getName();
    }

    public int getSuperIndex() {
        return this.i2;
    }

    FastClass getFastClass() {
        return this.f1;
    }

    FastClass getSuperFastClass() {
        return this.f2;
    }

    public static MethodProxy find(Class<?> type, Signature sig) {
        try {
            Method m = type.getDeclaredMethod("TODAY$findMethodProxy", MethodInterceptorGenerator.FIND_PROXY_TYPES);
            return (MethodProxy)m.invoke(null, sig);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Class " + type + " does not use a MethodInterceptor");
        }
        catch (IllegalAccessException e) {
            throw new CodeGenerationException(e);
        }
        catch (InvocationTargetException e) {
            throw new CodeGenerationException(e.getTargetException());
        }
    }

    public Object invoke(Object obj, Object[] args) throws Throwable {
        try {
            return this.f1.invoke(this.i1, obj, args);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
        catch (IllegalArgumentException e) {
            if (this.i1 < 0) {
                throw new IllegalArgumentException("Protected method: " + this.sig1);
            }
            throw e;
        }
    }

    public Object invokeSuper(Object obj, Object[] args) throws Throwable {
        try {
            return this.f2.invoke(this.i2, obj, args);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }
}

