/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.cglib.proxy;

import cn.taketoday.context.asm.Type;
import cn.taketoday.context.cglib.proxy.Callback;
import cn.taketoday.context.cglib.proxy.CallbackGenerator;
import cn.taketoday.context.cglib.proxy.Dispatcher;
import cn.taketoday.context.cglib.proxy.DispatcherGenerator;
import cn.taketoday.context.cglib.proxy.FixedValue;
import cn.taketoday.context.cglib.proxy.FixedValueGenerator;
import cn.taketoday.context.cglib.proxy.InvocationHandler;
import cn.taketoday.context.cglib.proxy.InvocationHandlerGenerator;
import cn.taketoday.context.cglib.proxy.LazyLoader;
import cn.taketoday.context.cglib.proxy.LazyLoaderGenerator;
import cn.taketoday.context.cglib.proxy.MethodInterceptor;
import cn.taketoday.context.cglib.proxy.MethodInterceptorGenerator;
import cn.taketoday.context.cglib.proxy.NoOp;
import cn.taketoday.context.cglib.proxy.NoOpGenerator;
import cn.taketoday.context.cglib.proxy.ProxyRefDispatcher;

class CallbackInfo {
    private final Class<?> cls;
    private final Type type;
    private final CallbackGenerator generator;
    private static final CallbackInfo[] CALLBACKS = new CallbackInfo[]{new CallbackInfo(NoOp.class, NoOpGenerator.INSTANCE), new CallbackInfo(MethodInterceptor.class, MethodInterceptorGenerator.INSTANCE), new CallbackInfo(InvocationHandler.class, InvocationHandlerGenerator.INSTANCE), new CallbackInfo(LazyLoader.class, LazyLoaderGenerator.INSTANCE), new CallbackInfo(Dispatcher.class, DispatcherGenerator.INSTANCE), new CallbackInfo(FixedValue.class, FixedValueGenerator.INSTANCE), new CallbackInfo(ProxyRefDispatcher.class, DispatcherGenerator.PROXY_REF_INSTANCE)};

    private CallbackInfo(Class<?> cls, CallbackGenerator generator) {
        this.cls = cls;
        this.generator = generator;
        this.type = Type.getType(cls);
    }

    private static Type determineType(Callback callback, boolean checkAll) {
        if (callback == null) {
            throw new IllegalStateException("Callback is null");
        }
        return CallbackInfo.determineType(callback.getClass(), checkAll);
    }

    private static Type determineType(Class<?> callbackType, boolean checkAll) {
        Class<?> cur = null;
        Type type = null;
        for (CallbackInfo info : CALLBACKS) {
            if (!info.cls.isAssignableFrom(callbackType)) continue;
            if (cur != null) {
                throw new IllegalStateException("Callback implements both " + cur + " and " + info.cls);
            }
            cur = info.cls;
            type = info.type;
            if (!checkAll) break;
        }
        if (cur == null) {
            throw new IllegalStateException("Unknown callback type " + callbackType);
        }
        return type;
    }

    private static CallbackGenerator getGenerator(Type callbackType) {
        for (CallbackInfo info : CALLBACKS) {
            if (!info.type.equals(callbackType)) continue;
            return info.generator;
        }
        throw new IllegalStateException("Unknown callback type " + callbackType);
    }

    public static Type[] determineTypes(Class<?>[] callbackTypes) {
        return CallbackInfo.determineTypes(callbackTypes, true);
    }

    public static Type[] determineTypes(Class<?>[] callbackTypes, boolean checkAll) {
        Type[] types = new Type[callbackTypes.length];
        int i = 0;
        for (Class<?> type : callbackTypes) {
            types[i++] = CallbackInfo.determineType(type, checkAll);
        }
        return types;
    }

    public static Type[] determineTypes(Callback[] callbacks) {
        return CallbackInfo.determineTypes(callbacks, true);
    }

    public static Type[] determineTypes(Callback[] callbacks, boolean checkAll) {
        Type[] types = new Type[callbacks.length];
        int i = 0;
        for (Callback callback : callbacks) {
            types[i++] = CallbackInfo.determineType(callback, checkAll);
        }
        return types;
    }

    public static CallbackGenerator[] getGenerators(Type[] callbackTypes) {
        CallbackGenerator[] generators = new CallbackGenerator[callbackTypes.length];
        int i = 0;
        for (Type callbackType : callbackTypes) {
            generators[i++] = CallbackInfo.getGenerator(callbackType);
        }
        return generators;
    }
}

