/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.cglib.core.internal;

import cn.taketoday.context.cglib.core.Customizer;
import cn.taketoday.context.cglib.core.KeyFactoryCustomizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CustomizerRegistry {
    private final Class<?>[] customizerTypes;
    private Map<Class<?>, List<KeyFactoryCustomizer>> customizers = new HashMap();

    public CustomizerRegistry(Class ... customizerTypes) {
        this.customizerTypes = customizerTypes;
    }

    public void add(KeyFactoryCustomizer customizer) {
        Class<?> klass = customizer.getClass();
        for (Class<?> type : this.customizerTypes) {
            if (!type.isAssignableFrom(klass)) continue;
            List<KeyFactoryCustomizer> list = this.customizers.get(type);
            if (list == null) {
                list = new ArrayList<KeyFactoryCustomizer>();
                this.customizers.put(type, list);
            }
            list.add(customizer);
        }
    }

    public <T> List<T> get(Class<T> klass) {
        List<KeyFactoryCustomizer> list = this.customizers.get(klass);
        return list == null ? Collections.emptyList() : list;
    }

    @Deprecated
    public static CustomizerRegistry singleton(Customizer customizer) {
        CustomizerRegistry registry = new CustomizerRegistry(Customizer.class);
        registry.add(customizer);
        return registry;
    }
}

