/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.cglib.core;

import cn.taketoday.context.asm.ClassReader;
import cn.taketoday.context.asm.ClassVisitor;
import cn.taketoday.context.asm.MethodVisitor;
import cn.taketoday.context.cglib.core.CglibReflectUtils;
import cn.taketoday.context.cglib.core.MethodWrapper;
import cn.taketoday.context.cglib.core.Signature;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;

public class DuplicatesPredicate
implements Predicate<Method> {
    private final Set<Object> unique = new HashSet<Object>();
    private final Set<Method> rejected;

    public DuplicatesPredicate() {
        this.rejected = Collections.emptySet();
    }

    public DuplicatesPredicate(List<Method> allMethods) {
        this.rejected = new HashSet<Method>();
        HashMap<Object, Method> scanned = new HashMap<Object, Method>();
        HashMap<Object, Method> suspects = new HashMap<Object, Method>();
        for (Method method : allMethods) {
            Object sig = MethodWrapper.create(method);
            Method method2 = (Method)scanned.get(sig);
            if (method2 == null) {
                scanned.put(sig, method);
                continue;
            }
            if (suspects.containsKey(sig) || !method2.isBridge() || method.isBridge()) continue;
            suspects.put(sig, method2);
        }
        if (!suspects.isEmpty()) {
            HashSet classes = new HashSet();
            UnnecessaryBridgeFinder finder = new UnnecessaryBridgeFinder(this.rejected);
            for (Method method : suspects.values()) {
                classes.add(method.getDeclaringClass());
                finder.addSuspectMethod(method);
            }
            for (Class clazz : classes) {
                ClassLoader cl = DuplicatesPredicate.getClassLoader(clazz);
                if (cl == null) continue;
                try {
                    InputStream is = cl.getResourceAsStream(clazz.getName().replace('.', '/') + ".class");
                    Throwable throwable = null;
                    try {
                        if (is == null) continue;
                        new ClassReader(is).accept(finder, 6);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (is == null) continue;
                        if (throwable != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        is.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public boolean test(Method arg) {
        return !this.rejected.contains(arg) && this.unique.add(MethodWrapper.create(arg));
    }

    private static ClassLoader getClassLoader(Class c) {
        ClassLoader cl = c.getClassLoader();
        if (cl == null) {
            cl = DuplicatesPredicate.class.getClassLoader();
        }
        if (cl == null) {
            cl = Thread.currentThread().getContextClassLoader();
        }
        return cl;
    }

    private static class UnnecessaryBridgeFinder
    extends ClassVisitor {
        private final Set<Method> rejected;
        private Signature currentMethodSig = null;
        private HashMap<Signature, Method> methods = new HashMap();

        UnnecessaryBridgeFinder(Set<Method> rejected) {
            this.rejected = rejected;
        }

        void addSuspectMethod(Method m) {
            this.methods.put(CglibReflectUtils.getSignature(m), m);
        }

        @Override
        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            Signature sig = new Signature(name, desc);
            final Method currentMethod = this.methods.remove(sig);
            if (currentMethod != null) {
                this.currentMethodSig = sig;
                return new MethodVisitor(){

                    @Override
                    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                        if (opcode == 183 && currentMethodSig != null) {
                            Signature target = new Signature(name, desc);
                            if (target.equals(currentMethodSig)) {
                                rejected.add(currentMethod);
                            }
                            currentMethodSig = null;
                        }
                    }
                };
            }
            return null;
        }
    }
}

