/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.cglib.core;

import cn.taketoday.context.cglib.core.NamingPolicy;
import java.util.function.Predicate;

public class DefaultNamingPolicy
implements NamingPolicy {
    public static final DefaultNamingPolicy INSTANCE = new DefaultNamingPolicy();
    private static final boolean STRESS_HASH_CODE = Boolean.getBoolean("cn.taketoday.context.cglib.test.stressHashCodes");

    @Override
    public String getClassName(String prefix, String source, Object key, Predicate<String> names) {
        String base;
        if (prefix == null) {
            prefix = "cn.taketoday.context.cglib.Object";
        } else if (prefix.startsWith("java")) {
            prefix = '$' + prefix;
        }
        String attempt = base = prefix + "$$" + source + this.getTag() + "$$" + Integer.toHexString(STRESS_HASH_CODE ? 0 : key.hashCode());
        int index = 2;
        while (names.test(attempt)) {
            attempt = base + '_' + index++;
        }
        return attempt;
    }

    protected String getTag() {
        return "ByTODAY";
    }

    public int hashCode() {
        return this.getTag().hashCode();
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof DefaultNamingPolicy && ((DefaultNamingPolicy)o).getTag().equals(this.getTag());
    }
}

