/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.cglib.beans;

import cn.taketoday.context.Constant;
import cn.taketoday.context.asm.ClassVisitor;
import cn.taketoday.context.asm.Type;
import cn.taketoday.context.cglib.core.AbstractClassGenerator;
import cn.taketoday.context.cglib.core.CglibReflectUtils;
import cn.taketoday.context.cglib.core.ClassEmitter;
import cn.taketoday.context.cglib.core.CodeEmitter;
import cn.taketoday.context.cglib.core.Converter;
import cn.taketoday.context.cglib.core.EmitUtils;
import cn.taketoday.context.cglib.core.KeyFactory;
import cn.taketoday.context.cglib.core.Local;
import cn.taketoday.context.cglib.core.MethodInfo;
import cn.taketoday.context.cglib.core.Signature;
import cn.taketoday.context.cglib.core.TypeUtils;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Modifier;
import java.security.ProtectionDomain;
import java.util.HashMap;

public abstract class BeanCopier {
    private static final Type CONVERTER = TypeUtils.parseType(Converter.class);
    private static final Type BEAN_COPIER = TypeUtils.parseType(BeanCopier.class);
    private static final BeanCopierKey KEY_FACTORY = KeyFactory.create(BeanCopierKey.class);
    private static final Signature COPY = new Signature("copy", Type.VOID_TYPE, Type.array(Constant.TYPE_OBJECT, Constant.TYPE_OBJECT, CONVERTER));
    private static final Signature CONVERT = TypeUtils.parseSignature("Object convert(Object, Class, Object)");

    public static BeanCopier create(Class source, Class target, boolean useConverter) {
        return new Generator(source, target, useConverter).create();
    }

    public abstract void copy(Object var1, Object var2, Converter var3);

    public static class Generator
    extends AbstractClassGenerator {
        private final Class source;
        private final Class target;
        private final boolean useConverter;

        public Generator(Class source, Class target, boolean useConverter) {
            super(BeanCopier.class);
            if (!Modifier.isPublic(source.getModifiers())) {
                this.setNamePrefix(source.getName());
            }
            if (!Modifier.isPublic(target.getModifiers())) {
                this.setNamePrefix(target.getName());
            }
            this.source = source;
            this.target = target;
            this.useConverter = useConverter;
        }

        @Override
        protected ClassLoader getDefaultClassLoader() {
            return this.source.getClassLoader();
        }

        @Override
        protected ProtectionDomain getProtectionDomain() {
            return CglibReflectUtils.getProtectionDomain(this.source);
        }

        public BeanCopier create() {
            return (BeanCopier)super.create(KEY_FACTORY.newInstance(this.source.getName(), this.target.getName(), this.useConverter));
        }

        @Override
        public void generateClass(ClassVisitor v) {
            Type sourceType = Type.getType(this.source);
            Type targetType = Type.getType(this.target);
            ClassEmitter ce = new ClassEmitter(v);
            ce.beginClass(52, 1, this.getClassName(), BEAN_COPIER, null, "<cglibGenerated>");
            EmitUtils.nullConstructor(ce);
            CodeEmitter e = ce.beginMethod(1, COPY, new Type[0]);
            PropertyDescriptor[] getters = CglibReflectUtils.getBeanGetters(this.source);
            PropertyDescriptor[] setters = CglibReflectUtils.getBeanSetters(this.target);
            HashMap<String, PropertyDescriptor> names = new HashMap<String, PropertyDescriptor>();
            for (int i = 0; i < getters.length; ++i) {
                names.put(getters[i].getName(), getters[i]);
            }
            Local targetLocal = e.make_local();
            Local sourceLocal = e.make_local();
            if (this.useConverter) {
                e.load_arg(1);
                e.checkcast(targetType);
                e.store_local(targetLocal);
                e.load_arg(0);
                e.checkcast(sourceType);
                e.store_local(sourceLocal);
            } else {
                e.load_arg(1);
                e.checkcast(targetType);
                e.load_arg(0);
                e.checkcast(sourceType);
            }
            for (int i = 0; i < setters.length; ++i) {
                PropertyDescriptor setter = setters[i];
                PropertyDescriptor getter = (PropertyDescriptor)names.get(setter.getName());
                if (getter == null) continue;
                MethodInfo read = CglibReflectUtils.getMethodInfo(getter.getReadMethod());
                MethodInfo write = CglibReflectUtils.getMethodInfo(setter.getWriteMethod());
                if (this.useConverter) {
                    Type setterType = write.getSignature().getArgumentTypes()[0];
                    e.load_local(targetLocal);
                    e.load_arg(2);
                    e.load_local(sourceLocal);
                    e.invoke(read);
                    e.box(read.getSignature().getReturnType());
                    EmitUtils.loadClass(e, setterType);
                    e.push(write.getSignature().getName());
                    e.invoke_interface(CONVERTER, CONVERT);
                    e.unbox_or_zero(setterType);
                    e.invoke(write);
                    continue;
                }
                if (!Generator.compatible(getter, setter)) continue;
                e.dup2();
                e.invoke(read);
                e.invoke(write);
            }
            e.return_value();
            e.end_method();
            ce.endClass();
        }

        private static boolean compatible(PropertyDescriptor getter, PropertyDescriptor setter) {
            return setter.getPropertyType().isAssignableFrom(getter.getPropertyType());
        }

        protected Object firstInstance(Class type) {
            return CglibReflectUtils.newInstance(type);
        }

        @Override
        protected Object nextInstance(Object instance) {
            return instance;
        }
    }

    static interface BeanCopierKey {
        public Object newInstance(String var1, String var2, boolean var3);
    }
}

