/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.cache.interceptor;

import cn.taketoday.cache.CacheManager;
import cn.taketoday.cache.annotation.CacheConfiguration;
import cn.taketoday.cache.annotation.CacheEvict;
import cn.taketoday.cache.interceptor.AbstractCacheInterceptor;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInvocation;

public class CacheEvictInterceptor
extends AbstractCacheInterceptor {
    public CacheEvictInterceptor() {
        this.setOrder(0x7FFFFFFE);
    }

    public CacheEvictInterceptor(CacheManager cacheManager) {
        this();
        this.setCacheManager(cacheManager);
    }

    @Override
    public Object invoke(MethodInvocation invocation) throws Throwable {
        Method method = invocation.getMethod();
        AbstractCacheInterceptor.MethodKey methodKey = new AbstractCacheInterceptor.MethodKey(method, CacheEvict.class);
        CacheConfiguration cacheEvict = AbstractCacheInterceptor.Operations.prepareAnnotation(methodKey);
        if (cacheEvict.beforeInvocation()) {
            if (cacheEvict.allEntries()) {
                this.clear(this.obtainCache(method, cacheEvict));
            } else {
                Object key = AbstractCacheInterceptor.Operations.createKey(cacheEvict.key(), AbstractCacheInterceptor.Operations.prepareELContext(methodKey, invocation), invocation);
                this.evict(this.obtainCache(method, cacheEvict), key);
            }
            return invocation.proceed();
        }
        Object proceed = invocation.proceed();
        if (cacheEvict.allEntries()) {
            this.clear(this.obtainCache(method, cacheEvict));
        } else {
            Object key = AbstractCacheInterceptor.Operations.createKey(cacheEvict.key(), AbstractCacheInterceptor.Operations.prepareELContext(methodKey, invocation), invocation);
            this.evict(this.obtainCache(method, cacheEvict), key);
        }
        return proceed;
    }
}

