/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.cache;

import cn.taketoday.cache.AbstractCacheManager;
import cn.taketoday.cache.Cache;
import cn.taketoday.cache.CacheManager;
import cn.taketoday.cache.RedissonCache;
import cn.taketoday.cache.annotation.CacheConfig;
import cn.taketoday.context.annotation.Autowired;
import org.redisson.api.RMap;
import org.redisson.api.RMapCache;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.Codec;

public class RedissonCacheManager
extends AbstractCacheManager
implements CacheManager {
    private Codec codec;
    private final RedissonClient redisson;

    public RedissonCacheManager(RedissonClient redisson) {
        this(null, redisson);
    }

    @Autowired
    public RedissonCacheManager(@Autowired(required=false) Codec codec, @Autowired RedissonClient redisson) {
        this.codec = codec;
        this.redisson = redisson;
    }

    @Override
    protected Cache doCreate(String name, CacheConfig cacheConfig) {
        return RedissonCacheManager.isDefaultConfig(cacheConfig) ? this.createMap(name) : this.createMapCache(name, cacheConfig);
    }

    public void setCodec(Codec codec) {
        this.codec = codec;
    }

    protected Cache createMap(String name) {
        return new RedissonCache(this.getMap(name), name);
    }

    protected RMap<Object, Object> getMap(String name) {
        return this.codec != null ? this.redisson.getMap(name, this.codec) : this.redisson.getMap(name);
    }

    private Cache createMapCache(String name, CacheConfig config) {
        RMapCache<Object, Object> map = this.getMapCache(name);
        RedissonCache cache = new RedissonCache((RMap<Object, Object>)map, name, config);
        map.setMaxSize(config.maxSize());
        return cache;
    }

    protected RMapCache<Object, Object> getMapCache(String name) {
        return this.codec != null ? this.redisson.getMapCache(name, this.codec) : this.redisson.getMapCache(name);
    }
}

