/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.cache;

import cn.taketoday.cache.AbstractCache;
import cn.taketoday.cache.Cache;
import cn.taketoday.cache.CacheCallback;
import cn.taketoday.cache.CacheValueRetrievalException;
import cn.taketoday.cache.annotation.CacheConfig;
import cn.taketoday.context.utils.Assert;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RLock;
import org.redisson.api.RMap;
import org.redisson.api.RMapCache;

public class RedissonCache
extends AbstractCache
implements Cache {
    private final CacheConfig cacheConfig;
    private final RMap<Object, Object> cache;

    public RedissonCache(RMap<Object, Object> cache) {
        this(cache, "default", null);
    }

    public RedissonCache(RMap<Object, Object> cache, String name) {
        this(cache, name, null);
    }

    public RedissonCache(RMap<Object, Object> cache, CacheConfig cacheConfig) {
        this(cache, cacheConfig.cacheName(), cacheConfig);
    }

    public RedissonCache(RMap<Object, Object> cache, String name, CacheConfig cacheConfig) {
        Assert.notNull((Object)name, "name must not be null");
        Assert.notNull(cache, "cache must not be null");
        this.cache = cache;
        this.cacheConfig = cacheConfig;
        this.setName(name);
    }

    protected static void doPut(RMap<Object, Object> cache, CacheConfig cacheConfig, Object key, Object value) {
        if (cacheConfig != null && cache instanceof RMapCache) {
            TimeUnit timeUnit = cacheConfig.timeUnit();
            ((RMapCache)cache).fastPut(key, value, cacheConfig.expire(), timeUnit, cacheConfig.maxIdleTime(), timeUnit);
        } else {
            cache.fastPut(key, value);
        }
    }

    @Override
    public void evict(Object key) {
        this.cache.fastRemove(new Object[]{key});
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    protected <T> Object lookupValue(Object key, CacheCallback<T> valueLoader) {
        RLock lock = this.cache.getLock(key);
        try {
            lock.lock();
            Object value = this.cache.get(key);
            if (value == null) {
                T newValue = valueLoader.call();
                this.put(key, newValue);
                T t = newValue;
                return t;
            }
            Object object = value;
            return object;
        }
        catch (Throwable ex) {
            throw new CacheValueRetrievalException(key, valueLoader, ex);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    protected Object lookupValue(Object key) {
        return this.cache.get(key);
    }

    @Override
    protected void putInternal(Object key, Object value) {
        RedissonCache.doPut(this.cache, this.cacheConfig, key, value);
    }
}

