/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.cache;

import cn.taketoday.cache.AbstractMappingFunctionCache;
import java.util.HashMap;
import java.util.Map;
import java.util.function.UnaryOperator;

public class DefaultMapCache
extends AbstractMappingFunctionCache {
    private final Map<Object, Object> store;

    public DefaultMapCache() {
        this("default");
    }

    public DefaultMapCache(String name) {
        this(name, 256);
    }

    public DefaultMapCache(String name, int size) {
        this(name, new HashMap<Object, Object>(size));
    }

    protected DefaultMapCache(String name, Map<Object, Object> store) {
        this.setName(name);
        this.store = store;
    }

    @Override
    protected Object lookupValue(Object key) {
        return this.store.get(key);
    }

    @Override
    public void evict(Object key) {
        this.store.remove(key);
    }

    @Override
    public void clear() {
        this.store.clear();
    }

    @Override
    protected void putInternal(Object key, Object value) {
        this.store.put(key, value);
    }

    @Override
    protected Object getInternal(Object key, UnaryOperator<Object> mappingFunction) {
        return this.store.computeIfAbsent(key, mappingFunction);
    }
}

