/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.cache;

import cn.taketoday.cache.Cache;
import cn.taketoday.cache.CacheManager;
import cn.taketoday.cache.annotation.CacheConfig;
import cn.taketoday.context.utils.Assert;
import cn.taketoday.context.utils.ObjectUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;

public class CompositeCacheManager
implements CacheManager {
    private final List<CacheManager> cacheManagers = new ArrayList<CacheManager>();

    public CompositeCacheManager() {
    }

    public CompositeCacheManager(CacheManager ... cacheManagers) {
        Assert.notNull((Object)cacheManagers, "cacheManager s can't be null");
        Collections.addAll(this.cacheManagers, cacheManagers);
    }

    public void addCacheManagers(Collection<CacheManager> cacheManagers) {
        Assert.notNull(cacheManagers, "cacheManager s can't be null");
        this.cacheManagers.addAll(cacheManagers);
    }

    public void setCacheManagers(Collection<CacheManager> cacheManagers) {
        Assert.notNull(cacheManagers, "cacheManager s can't be null");
        this.cacheManagers.clear();
        this.cacheManagers.addAll(cacheManagers);
    }

    @Override
    public Cache getCache(String name, CacheConfig cacheConfig) {
        for (CacheManager cacheManager : this.cacheManagers) {
            Cache cache = cacheManager.getCache(name, cacheConfig);
            if (cache == null) continue;
            return cache;
        }
        return null;
    }

    @Override
    public Collection<String> getCacheNames() {
        if (ObjectUtils.isEmpty(this.cacheManagers)) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        for (CacheManager manager : this.cacheManagers) {
            names.addAll(manager.getCacheNames());
        }
        return names;
    }
}

