/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.cache;

import cn.taketoday.cache.AbstractMappingFunctionCache;
import cn.taketoday.context.utils.Assert;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.function.UnaryOperator;

public class CaffeineCache
extends AbstractMappingFunctionCache {
    private final Cache<Object, Object> caffeine;

    public CaffeineCache(String name, Cache<Object, Object> caffeine) {
        Assert.notNull((Object)name, "Name must not be null");
        Assert.notNull(caffeine, "com.github.benmanes.caffeine.cache.Cache must not be null");
        this.caffeine = caffeine;
        this.setName(name);
    }

    @Override
    public void evict(Object key) {
        this.caffeine.invalidate(key);
    }

    @Override
    public void clear() {
        this.caffeine.invalidateAll();
    }

    @Override
    protected Object getInternal(Object key, UnaryOperator<Object> mappingFunction) {
        return this.caffeine.get(key, mappingFunction);
    }

    @Override
    protected Object lookupValue(Object key) {
        if (this.caffeine instanceof LoadingCache) {
            return ((LoadingCache)this.caffeine).get(key);
        }
        return this.caffeine.getIfPresent(key);
    }

    @Override
    protected void putInternal(Object key, Object value) {
        this.caffeine.put(key, value);
    }
}

