/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.cache;

import cn.taketoday.cache.Cache;
import cn.taketoday.cache.CacheCallback;
import cn.taketoday.cache.CacheValueRetrievalException;
import cn.taketoday.context.EmptyObject;

public abstract class AbstractCache
implements Cache {
    private String name;

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public final Object get(Object key) {
        return this.get(key, true);
    }

    @Override
    public final Object get(Object key, boolean unWarp) {
        Object userValue = this.lookupValue(key);
        return unWarp ? AbstractCache.toRealValue(userValue) : userValue;
    }

    protected static Object toStoreValue(Object userValue) {
        return userValue == null ? EmptyObject.INSTANCE : userValue;
    }

    protected static Object toRealValue(Object cachedValue) {
        return cachedValue == EmptyObject.INSTANCE ? null : cachedValue;
    }

    @Override
    public <T> T get(Object key, Class<T> type) {
        Object value = this.get(key);
        if (value != null && type != null && !type.isInstance(value)) {
            throw new IllegalStateException("Cached value is not of required type [" + type.getName() + "]: " + value);
        }
        return (T)value;
    }

    @Override
    public final <T> T get(Object key, CacheCallback<T> valueLoader) {
        return (T)AbstractCache.toRealValue(this.getInternal(key, valueLoader));
    }

    protected <T> Object getInternal(Object key, CacheCallback<T> valueLoader) {
        Object ret = this.lookupValue(key);
        if (ret == null) {
            ret = this.lookupValue(key, valueLoader);
        }
        return ret;
    }

    protected abstract Object lookupValue(Object var1);

    protected <T> Object lookupValue(Object key, CacheCallback<T> valueLoader) {
        try {
            return valueLoader.call();
        }
        catch (Throwable e) {
            throw new CacheValueRetrievalException(key, valueLoader, e);
        }
    }

    @Override
    public final void put(Object key, Object value) {
        this.putInternal(key, AbstractCache.toStoreValue(value));
    }

    protected abstract void putInternal(Object var1, Object var2);
}

