/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop.target;

import cn.taketoday.aop.TargetSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractLazyCreationTargetSource
implements TargetSource {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Object lazyTarget;

    public synchronized boolean isInitialized() {
        return this.lazyTarget != null;
    }

    @Override
    public synchronized Class<?> getTargetClass() {
        return this.lazyTarget != null ? this.lazyTarget.getClass() : null;
    }

    @Override
    public boolean isStatic() {
        return false;
    }

    @Override
    public synchronized Object getTarget() {
        if (this.lazyTarget == null) {
            this.logger.debug((Object)"Initializing lazy target object");
            this.lazyTarget = this.createObject();
        }
        return this.lazyTarget;
    }

    protected abstract Object createObject();
}

