/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop.support;

import cn.taketoday.context.factory.ObjectSupplier;
import cn.taketoday.context.utils.Assert;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class SuppliedMethodInterceptor
implements MethodInterceptor {
    final ObjectSupplier<MethodInterceptor> supplier;

    public SuppliedMethodInterceptor(ObjectSupplier<MethodInterceptor> interceptorSupplier) {
        Assert.notNull(interceptorSupplier, "interceptorSupplier must not be null");
        this.supplier = interceptorSupplier;
    }

    MethodInterceptor obtainInterceptor() {
        MethodInterceptor ret = this.supplier.getIfAvailable();
        Assert.state(ret != null, "No MethodInterceptor");
        return ret;
    }

    @Override
    public Object invoke(MethodInvocation invocation) throws Throwable {
        return this.obtainInterceptor().invoke(invocation);
    }
}

