/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop.support;

import cn.taketoday.aop.Advisor;
import cn.taketoday.aop.TargetSource;
import cn.taketoday.aop.proxy.AopConfigException;
import cn.taketoday.aop.proxy.ProxyCreatorSupport;
import cn.taketoday.aop.proxy.ProxyFactory;
import cn.taketoday.aop.support.AopUtils;
import cn.taketoday.aop.target.SingletonTargetSource;
import cn.taketoday.context.aware.BeanClassLoaderAware;
import cn.taketoday.context.aware.BeanFactoryAware;
import cn.taketoday.context.factory.BeanFactory;
import cn.taketoday.context.factory.FactoryBean;
import cn.taketoday.context.utils.ClassUtils;
import cn.taketoday.context.utils.ObjectUtils;
import java.util.Set;

public class ProxyFactoryBean
extends ProxyCreatorSupport
implements FactoryBean<Object>,
BeanFactoryAware,
BeanClassLoaderAware {
    private String targetName;
    private String[] interceptorNames;
    private BeanFactory beanFactory;
    private Set<Class<?>> proxyInterfaces;
    private ClassLoader classLoader = ClassUtils.getClassLoader();

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public String[] getInterceptorNames() {
        return this.interceptorNames;
    }

    public Set<Class<?>> getProxyInterfaces() {
        return this.proxyInterfaces;
    }

    public void setTargetName(String targetName) {
        this.targetName = targetName;
    }

    public void setInterceptorNames(String ... interceptorNames) {
        this.interceptorNames = interceptorNames;
    }

    public void setProxyInterfaces(Set<Class<?>> proxyInterfaces) {
        this.proxyInterfaces = proxyInterfaces;
    }

    public BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    @Override
    public Object getBean() {
        BeanFactory beanFactory = this.getBeanFactory();
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.copyFrom(this);
        proxyFactory.setTargetSource(this.getTargetSource());
        if (ObjectUtils.isNotEmpty(this.interceptorNames)) {
            for (String interceptorName : this.interceptorNames) {
                Object interceptor = beanFactory.getBean(interceptorName);
                if (interceptor == null) {
                    throw new AopConfigException("Cannot determine an Advice or Advisor by interceptorName '" + interceptorName + "' from beanFactory:" + beanFactory);
                }
                Advisor wrap = AopUtils.wrap(interceptor);
                proxyFactory.addAdvisor(wrap);
            }
        }
        return proxyFactory.getProxy(this.classLoader);
    }

    @Override
    public TargetSource getTargetSource() {
        Object target = this.beanFactory.getBean(this.targetName);
        return target instanceof TargetSource ? (TargetSource)target : new SingletonTargetSource(target);
    }

    @Override
    public Class<Object> getBeanClass() {
        return null;
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    @Override
    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }
}

